/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;

public class BriefJUnitResultFormatter
implements JUnitResultFormatter {
    private OutputStream out;
    private PrintWriter output;
    private StringWriter results;
    private PrintWriter resultWriter;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private String systemOutput = null;
    private String systemError = null;

    public BriefJUnitResultFormatter() {
        this.results = new StringWriter();
        this.resultWriter = new PrintWriter(this.results);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
        this.output = new PrintWriter(out);
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public void startTestSuite(JUnitTest suite) throws BuildException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Testsuite: ");
        sb.append(suite.getName());
        sb.append(newLine);
        sb.append("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Time elapsed: ");
        sb.append(this.numberFormat.format((double)suite.getRunTime() / 1000.0));
        sb.append(" sec");
        sb.append(newLine);
        sb.append(newLine);
        if (this.systemOutput != null && this.systemOutput.length() > 0) {
            sb.append("------------- Standard Output ---------------").append(newLine).append(this.systemOutput).append("------------- ---------------- ---------------").append(newLine);
        }
        if (this.systemError != null && this.systemError.length() > 0) {
            sb.append("------------- Standard Error -----------------").append(newLine).append(this.systemError).append("------------- ---------------- ---------------").append(newLine);
        }
        if (this.output == null) return;
        try {
            this.output.write(sb.toString());
            this.resultWriter.close();
            this.output.write(this.results.toString());
            this.output.flush();
            Object var5_4 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.out == System.out || this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.out.close();
            return;
        }
        catch (IOException e) {}
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable error) {
        this.formatError("\tCaused an ERROR", test, error);
    }

    protected String formatTest(Test test) {
        if (test == null) {
            return "Null Test: ";
        }
        return "Testcase: " + test.toString() + ":";
    }

    protected synchronized void formatError(String type, Test test, Throwable error) {
        if (test != null) {
            this.endTest(test);
        }
        this.resultWriter.println(this.formatTest(test) + type);
        this.resultWriter.println(error.getMessage());
        String strace = JUnitTestRunner.getFilteredTrace(error);
        this.resultWriter.println(strace);
        this.resultWriter.println();
    }
}

