/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.swing;

import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.JFrame;

public class ScreenManager {
    private GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();

    public void setFullScreen(JFrame window) {
        window.setUndecorated(true);
        window.setResizable(false);
        this.environment.getDefaultScreenDevice().setFullScreenWindow(window);
        if (this.environment.getDefaultScreenDevice().isDisplayChangeSupported()) {
            DisplayMode mode = new DisplayMode((int)this.environment.getMaximumWindowBounds().getWidth(), (int)this.environment.getMaximumWindowBounds().getWidth(), 24, 0);
            this.environment.getDefaultScreenDevice().setDisplayMode(mode);
        }
    }

    public Window getFullScreenWindow() {
        return this.environment.getDefaultScreenDevice().getFullScreenWindow();
    }

    public void restoreScreen() {
        Window window = this.environment.getDefaultScreenDevice().getFullScreenWindow();
        if (window != null) {
            window.dispose();
        }
        this.environment.getDefaultScreenDevice().setFullScreenWindow(null);
    }
}

