/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class SerializableConstructor
implements Serializable {
    private Constructor constructor = null;

    public SerializableConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public SerializableConstructor(Class clazz, Class[] parameterTypes) throws NoSuchMethodException {
        this.constructor = ClassUtil.resolveConstructor(clazz, parameterTypes);
    }

    public Constructor deSerialize() {
        return this.constructor;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.constructor.getDeclaringClass());
            out.writeObject(new MethodSignature(this.constructor));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            Class declaringClass = (Class)in.readObject();
            MethodSignature signature = (MethodSignature)in.readObject();
            this.constructor = ClassUtil.resolveConstructor(declaringClass, signature.getParameterTypes());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

