/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.operations.JumpOperation;

public class TABLESWITCH
extends JumpOperation {
    public static final int OP = 170;
    private int byteLength = 0;
    private int lowValue = -1;
    private int highValue = -1;
    private List offsets = new ArrayList();

    public TABLESWITCH(DataInput dataInput, int padding) throws IOException {
        if (padding > 0) {
            dataInput.skipBytes(padding);
            this.byteLength += padding;
        }
        this.offsets.add(new Integer(dataInput.readInt()));
        this.lowValue = dataInput.readInt();
        this.highValue = dataInput.readInt();
        int entries = this.highValue - this.lowValue + 1;
        this.byteLength += 12;
        for (int i = 0; i < entries; ++i) {
            Integer offset = new Integer(dataInput.readInt());
            this.offsets.add(offset);
            this.byteLength += 4;
        }
    }

    public int execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        int index = (Integer)stack.pop();
        int offset = -1;
        offset = index < this.lowValue || index > this.highValue ? ((Integer)this.offsets.get(0)).intValue() : ((Integer)this.offsets.get(index - this.lowValue + 1)).intValue();
        return offset;
    }

    public int getByteLength() {
        return 1 + this.byteLength;
    }

    public int getOpcode() {
        return 170;
    }
}

