/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.operations.JumpOperation;

public class LOOKUPSWITCH
extends JumpOperation {
    public static final int OP = 171;
    private int byteLength = 0;
    private Map offsets = new HashMap();

    public LOOKUPSWITCH(DataInput dataInput, int padding) throws IOException {
        if (padding > 0) {
            dataInput.skipBytes(padding);
            this.byteLength += padding;
        }
        this.offsets.put("default", new Integer(dataInput.readInt()));
        int entries = dataInput.readInt();
        this.byteLength += 8;
        for (int i = 0; i < entries; ++i) {
            Integer match = new Integer(dataInput.readInt());
            Integer offset = new Integer(dataInput.readInt());
            this.offsets.put(match, offset);
            this.byteLength += 8;
        }
    }

    public int execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        Integer key = (Integer)stack.pop();
        Integer offset = (Integer)this.offsets.get(key);
        if (offset == null) {
            offset = (Integer)this.offsets.get("default");
        }
        return offset;
    }

    public int getByteLength() {
        return 1 + this.byteLength;
    }

    public int getOpcode() {
        return 171;
    }
}

