/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantFieldref;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.language.reflection.ClassUtil;

public class GETFIELD
extends VoidOperation {
    public static final int OP = 180;
    private int index = -1;
    private final Map CACHE = new HashMap();

    public GETFIELD(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        try {
            Field field = null;
            Object objectRef = stack.pop();
            if (this.CACHE.containsKey(objectRef.getClass())) {
                field = (Field)this.CACHE.get(objectRef.getClass());
            } else {
                ConstantFieldref constantFieldref = (ConstantFieldref)constantPool[this.index];
                field = ClassUtil.resolveField((Object)objectRef, (String)constantFieldref.getConstantNameAndType().getName());
                ((AccessibleObject)field).setAccessible(true);
                this.CACHE.put(objectRef.getClass(), field);
            }
            stack.push(field.get(objectRef));
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 180;
    }
}

