/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantClass;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;

public class CHECKCAST
extends VoidOperation {
    public static final int OP = 192;
    private int index = -1;

    public CHECKCAST(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        Object objectReference = stack.peek();
        if (objectReference == null) {
            return;
        }
        Class clazz = null;
        try {
            clazz = ((ConstantClass)constantPool[this.index]).getValue().getClassValue();
        }
        catch (ClassNotFoundException exception) {
            throw new InterpreterException(exception);
        }
        if (!clazz.isAssignableFrom(objectReference.getClass())) {
            throw new ClassCastException("CHECKCAST operation failed");
        }
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 192;
    }
}

