/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantClass;

public class ExceptionEntry {
    private int startByte;
    private int endByte;
    private int handler;
    private Class catchType = class$java$lang$Exception == null ? (class$java$lang$Exception = ExceptionEntry.class$("java.lang.Exception")) : class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Exception;

    public ExceptionEntry(DataInput dataInput, Constant[] constantPool) throws IOException {
        this.startByte = dataInput.readUnsignedShort();
        this.endByte = dataInput.readUnsignedShort();
        this.handler = dataInput.readUnsignedShort();
        int catchTypeIndex = dataInput.readUnsignedShort();
        if (catchTypeIndex > 0) {
            try {
                this.catchType = ((ConstantClass)constantPool[catchTypeIndex]).getValue().getClassValue();
            }
            catch (Exception exception) {
                throw new IOException("could not resolve catchType in ExceptionEntry");
            }
        }
    }

    public Class getCatchType() {
        return this.catchType;
    }

    public int getEndByte() {
        return this.endByte;
    }

    public int getHandler() {
        return this.handler;
    }

    public int getStartByte() {
        return this.startByte;
    }

    public static ExceptionEntry resolveExceptionEntry(ExceptionEntry[] entries, Class exceptionType, int bytePosition) {
        if (entries == null || exceptionType == null) {
            return null;
        }
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getCatchType().isAssignableFrom(exceptionType) || bytePosition < entries[i].getStartByte() || bytePosition > entries[i].getEndByte()) continue;
            return entries[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

