/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

public class Blas_f77 {
    public static int isamax_f77(int n, double[] dArray, int n2) {
        int n3;
        if (n < 1) {
            n3 = 0;
        } else if (n == 1) {
            n3 = 1;
        } else if (n2 == 1) {
            n3 = 1;
            double d = Math.abs(dArray[1]);
            for (int i = 2; i <= n; ++i) {
                if (!(Math.abs(dArray[i]) > d)) continue;
                n3 = i;
                d = Math.abs(dArray[i]);
            }
        } else {
            n3 = 1;
            int n4 = 1;
            double d = Math.abs(dArray[n4]);
            n4 += n2;
            for (int i = 2; i <= n; ++i) {
                if (Math.abs(dArray[n4]) > d) {
                    n3 = i;
                    d = Math.abs(dArray[n4]);
                }
                n4 += n2;
            }
        }
        return n3;
    }

    public static int colisamax_f77(int n, double[][] dArray, int n2, int n3, int n4) {
        int n5;
        if (n < 1) {
            n5 = 0;
        } else if (n == 1) {
            n5 = 1;
        } else if (n2 == 1) {
            n5 = 1;
            int n6 = n3;
            double d = Math.abs(dArray[n6][n4]);
            ++n6;
            for (int i = 2; i <= n; ++i) {
                if (Math.abs(dArray[n6][n4]) > d) {
                    n5 = i;
                    d = Math.abs(dArray[n6][n4]);
                }
                ++n6;
            }
        } else {
            n5 = 1;
            int n7 = n3;
            double d = Math.abs(dArray[n7][n4]);
            n7 += n2;
            for (int i = 2; i <= n; ++i) {
                if (Math.abs(dArray[n7][n4]) > d) {
                    n5 = i;
                    d = Math.abs(dArray[n7][n4]);
                }
                n7 += n2;
            }
        }
        return n5;
    }

    public static void daxpy_f77(int n, double d, double[] dArray, int n2, double[] dArray2, int n3) {
        if (n <= 0) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (n2 == 1 && n3 == 1) {
            int n4;
            int n5 = n % 4;
            for (n4 = 1; n4 <= n5; ++n4) {
                int n6 = n4;
                dArray2[n6] = dArray2[n6] + d * dArray[n4];
            }
            for (n4 = n5 + 1; n4 <= n; n4 += 4) {
                int n7 = n4;
                dArray2[n7] = dArray2[n7] + d * dArray[n4];
                int n8 = n4 + 1;
                dArray2[n8] = dArray2[n8] + d * dArray[n4 + 1];
                int n9 = n4 + 2;
                dArray2[n9] = dArray2[n9] + d * dArray[n4 + 2];
                int n10 = n4 + 3;
                dArray2[n10] = dArray2[n10] + d * dArray[n4 + 3];
            }
            return;
        }
        int n11 = 1;
        int n12 = 1;
        if (n2 < 0) {
            n11 = (-n + 1) * n2 + 1;
        }
        if (n3 < 0) {
            n12 = (-n + 1) * n3 + 1;
        }
        for (int i = 1; i <= n; ++i) {
            int n13 = n12;
            dArray2[n13] = dArray2[n13] + d * dArray[n11];
            n11 += n2;
            n12 += n3;
        }
    }

    public static double ddot_f77(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        double d = 0.0;
        if (n <= 0) {
            return d;
        }
        if (n2 == 1 && n3 == 1) {
            int n4;
            int n5 = n % 5;
            for (n4 = 1; n4 <= n5; ++n4) {
                d += dArray[n4] * dArray2[n4];
            }
            for (n4 = n5 + 1; n4 <= n; n4 += 5) {
                d += dArray[n4] * dArray2[n4] + dArray[n4 + 1] * dArray2[n4 + 1] + dArray[n4 + 2] * dArray2[n4 + 2] + dArray[n4 + 3] * dArray2[n4 + 3] + dArray[n4 + 4] * dArray2[n4 + 4];
            }
            return d;
        }
        int n6 = 1;
        int n7 = 1;
        if (n2 < 0) {
            n6 = (-n + 1) * n2 + 1;
        }
        if (n3 < 0) {
            n7 = (-n + 1) * n3 + 1;
        }
        for (int i = 1; i <= n; ++i) {
            d += dArray[n6] * dArray2[n7];
            n6 += n2;
            n7 += n3;
        }
        return d;
    }

    public static void dscal_f77(int n, double d, double[] dArray, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (n2 == 1) {
            int n3 = n % 5;
            int n4 = 1;
            while (n4 <= n3) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] * d;
            }
            for (n4 = n3 + 1; n4 <= n; n4 += 5) {
                int n6 = n4;
                dArray[n6] = dArray[n6] * d;
                int n7 = n4 + 1;
                dArray[n7] = dArray[n7] * d;
                int n8 = n4 + 2;
                dArray[n8] = dArray[n8] * d;
                int n9 = n4 + 3;
                dArray[n9] = dArray[n9] * d;
                int n10 = n4 + 4;
                dArray[n10] = dArray[n10] * d;
            }
            return;
        }
        int n11 = n * n2;
        for (int i = 1; i <= n11; i += n2) {
            int n12 = i;
            dArray[n12] = dArray[n12] * d;
        }
    }

    public static void dswap_f77(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        if (n <= 0) {
            return;
        }
        if (n2 == 1 && n3 == 1) {
            double d;
            int n4;
            int n5 = n % 3;
            for (n4 = 1; n4 <= n5; ++n4) {
                d = dArray[n4];
                dArray[n4] = dArray2[n4];
                dArray2[n4] = d;
            }
            for (n4 = n5 + 1; n4 <= n; n4 += 3) {
                d = dArray[n4];
                dArray[n4] = dArray2[n4];
                dArray2[n4] = d;
                d = dArray[n4 + 1];
                dArray[n4 + 1] = dArray2[n4 + 1];
                dArray2[n4 + 1] = d;
                d = dArray[n4 + 2];
                dArray[n4 + 2] = dArray2[n4 + 2];
                dArray2[n4 + 2] = d;
            }
            return;
        }
        int n6 = 1;
        int n7 = 1;
        if (n2 < 0) {
            n6 = (-n + 1) * n2 + 1;
        }
        if (n3 < 0) {
            n7 = (-n + 1) * n3 + 1;
        }
        for (int i = 1; i <= n; ++i) {
            double d = dArray[n6];
            dArray[n6] = dArray2[n7];
            dArray2[n7] = d;
            n6 += n2;
            n7 += n3;
        }
    }

    public static double dnrm2_f77(int n, double[] dArray, int n2) {
        double d;
        if (n < 1 || n2 < 1) {
            d = 0.0;
        } else if (n == 1) {
            d = Math.abs(dArray[1]);
        } else {
            double d2 = 0.0;
            double d3 = 1.0;
            int n3 = 1 + (n - 1) * n2;
            for (int i = 1; i <= n3; i += n2) {
                double d4;
                if (dArray[i] == 0.0) continue;
                double d5 = Math.abs(dArray[i]);
                if (d2 < d5) {
                    d4 = d2 / d5;
                    d3 = 1.0 + d3 * d4 * d4;
                    d2 = d5;
                    continue;
                }
                d4 = d5 / d2;
                d3 += d4 * d4;
            }
            d = d2 * Math.sqrt(d3);
        }
        return d;
    }

    public static void dcopy_f77(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        if (n <= 0) {
            return;
        }
        if (n2 == 1 && n3 == 1) {
            int n4;
            int n5 = n % 7;
            for (n4 = 1; n4 <= n5; ++n4) {
                dArray2[n4] = dArray[n4];
            }
            for (n4 = n5 + 1; n4 <= n; n4 += 7) {
                dArray2[n4] = dArray[n4];
                dArray2[n4 + 1] = dArray[n4 + 1];
                dArray2[n4 + 2] = dArray[n4 + 2];
                dArray2[n4 + 3] = dArray[n4 + 3];
                dArray2[n4 + 4] = dArray[n4 + 4];
                dArray2[n4 + 5] = dArray[n4 + 5];
                dArray2[n4 + 6] = dArray[n4 + 6];
            }
            return;
        }
        int n6 = 1;
        int n7 = 1;
        if (n2 < 0) {
            n6 = (-n + 1) * n2 + 1;
        }
        if (n3 < 0) {
            n7 = (-n + 1) * n3 + 1;
        }
        for (int i = 1; i <= n; ++i) {
            dArray2[n7] = dArray[n6];
            n6 += n2;
            n7 += n3;
        }
    }

    public static void drotg_f77(double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = dArray[1];
        double d8 = d6 = dArray[2];
        if (Math.abs(d7) > Math.abs(d6)) {
            d8 = d7;
        }
        if ((d5 = Math.abs(d7) + Math.abs(d6)) != 0.0) {
            double d9 = d7 / d5;
            double d10 = d6 / d5;
            d4 = d5 * Math.sqrt(d9 * d9 + d10 * d10);
            d4 = Blas_f77.sign_f77(1.0, d8) * d4;
            d3 = d7 / d4;
            d2 = d6 / d4;
            d = 1.0;
            if (Math.abs(d7) > Math.abs(d6)) {
                d = d2;
            }
            if (Math.abs(d6) >= Math.abs(d7) && d3 != 0.0) {
                d = 1.0 / d3;
            }
        } else {
            d3 = 1.0;
            d2 = 0.0;
            d4 = 0.0;
            d = 0.0;
        }
        d7 = d4;
        d6 = d;
        dArray[1] = d7;
        dArray[2] = d6;
        dArray[3] = d3;
        dArray[4] = d2;
    }

    public static void colaxpy_f77(int n, double d, double[][] dArray, int n2, int n3, int n4) {
        int n5;
        if (n <= 0) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        int n6 = n % 4;
        int n7 = n6 + n2;
        int n8 = n2 + n - 1;
        for (n5 = n2; n5 < n7; ++n5) {
            double[] dArray2 = dArray[n5];
            int n9 = n4;
            dArray2[n9] = dArray2[n9] + d * dArray[n5][n3];
        }
        for (n5 = n7; n5 <= n8; n5 += 4) {
            double[] dArray3 = dArray[n5];
            int n10 = n4;
            dArray3[n10] = dArray3[n10] + d * dArray[n5][n3];
            double[] dArray4 = dArray[n5 + 1];
            int n11 = n4;
            dArray4[n11] = dArray4[n11] + d * dArray[n5 + 1][n3];
            double[] dArray5 = dArray[n5 + 2];
            int n12 = n4;
            dArray5[n12] = dArray5[n12] + d * dArray[n5 + 2][n3];
            double[] dArray6 = dArray[n5 + 3];
            int n13 = n4;
            dArray6[n13] = dArray6[n13] + d * dArray[n5 + 3][n3];
        }
    }

    public static void colvaxpy_f77(int n, double d, double[][] dArray, double[] dArray2, int n2, int n3) {
        int n4;
        if (n <= 0) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        int n5 = n % 4;
        int n6 = n5 + n2;
        int n7 = n2 + n - 1;
        for (n4 = n2; n4 < n6; ++n4) {
            int n8 = n4;
            dArray2[n8] = dArray2[n8] + d * dArray[n4][n3];
        }
        for (n4 = n6; n4 <= n7; n4 += 4) {
            int n9 = n4;
            dArray2[n9] = dArray2[n9] + d * dArray[n4][n3];
            int n10 = n4 + 1;
            dArray2[n10] = dArray2[n10] + d * dArray[n4 + 1][n3];
            int n11 = n4 + 2;
            dArray2[n11] = dArray2[n11] + d * dArray[n4 + 2][n3];
            int n12 = n4 + 3;
            dArray2[n12] = dArray2[n12] + d * dArray[n4 + 3][n3];
        }
    }

    public static void colvraxpy_f77(int n, double d, double[] dArray, double[][] dArray2, int n2, int n3) {
        int n4;
        if (n <= 0) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        int n5 = n % 4;
        int n6 = n5 + n2;
        int n7 = n2 + n - 1;
        for (n4 = n2; n4 < n6; ++n4) {
            double[] dArray3 = dArray2[n4];
            int n8 = n3;
            dArray3[n8] = dArray3[n8] + d * dArray[n4];
        }
        for (n4 = n6; n4 <= n7; n4 += 4) {
            double[] dArray4 = dArray2[n4];
            int n9 = n3;
            dArray4[n9] = dArray4[n9] + d * dArray[n4];
            double[] dArray5 = dArray2[n4 + 1];
            int n10 = n3;
            dArray5[n10] = dArray5[n10] + d * dArray[n4 + 1];
            double[] dArray6 = dArray2[n4 + 2];
            int n11 = n3;
            dArray6[n11] = dArray6[n11] + d * dArray[n4 + 2];
            double[] dArray7 = dArray2[n4 + 3];
            int n12 = n3;
            dArray7[n12] = dArray7[n12] + d * dArray[n4 + 3];
        }
    }

    public static double coldot_f77(int n, double[][] dArray, int n2, int n3, int n4) {
        int n5;
        double d = 0.0;
        if (n <= 0) {
            return d;
        }
        int n6 = n % 5;
        int n7 = n6 + n2;
        int n8 = n2 + n - 1;
        for (n5 = n2; n5 < n7; ++n5) {
            d += dArray[n5][n3] * dArray[n5][n4];
        }
        for (n5 = n7; n5 <= n8; n5 += 5) {
            d += dArray[n5][n3] * dArray[n5][n4] + dArray[n5 + 1][n3] * dArray[n5 + 1][n4] + dArray[n5 + 2][n3] * dArray[n5 + 2][n4] + dArray[n5 + 3][n3] * dArray[n5 + 3][n4] + dArray[n5 + 4][n3] * dArray[n5 + 4][n4];
        }
        return d;
    }

    public static double colvdot_f77(int n, double[][] dArray, double[] dArray2, int n2, int n3) {
        int n4;
        double d = 0.0;
        if (n <= 0) {
            return d;
        }
        int n5 = n % 5;
        int n6 = n5 + n2;
        int n7 = n2 + n - 1;
        for (n4 = n2; n4 < n6; ++n4) {
            d += dArray[n4][n3] * dArray2[n4];
        }
        for (n4 = n6; n4 <= n7; n4 += 5) {
            d += dArray[n4][n3] * dArray2[n4] + dArray[n4 + 1][n3] * dArray2[n4 + 1] + dArray[n4 + 2][n3] * dArray2[n4 + 2] + dArray[n4 + 3][n3] * dArray2[n4 + 3] + dArray[n4 + 4][n3] * dArray2[n4 + 4];
        }
        return d;
    }

    public static void colscal_f77(int n, double d, double[][] dArray, int n2, int n3) {
        int n4;
        if (n <= 0) {
            return;
        }
        int n5 = n % 5;
        int n6 = n5 + n2;
        int n7 = n2 + n - 1;
        for (n4 = n2; n4 < n6; ++n4) {
            double[] dArray2 = dArray[n4];
            int n8 = n3;
            dArray2[n8] = dArray2[n8] * d;
        }
        for (n4 = n6; n4 <= n7; n4 += 5) {
            double[] dArray3 = dArray[n4];
            int n9 = n3;
            dArray3[n9] = dArray3[n9] * d;
            double[] dArray4 = dArray[n4 + 1];
            int n10 = n3;
            dArray4[n10] = dArray4[n10] * d;
            double[] dArray5 = dArray[n4 + 2];
            int n11 = n3;
            dArray5[n11] = dArray5[n11] * d;
            double[] dArray6 = dArray[n4 + 3];
            int n12 = n3;
            dArray6[n12] = dArray6[n12] * d;
            double[] dArray7 = dArray[n4 + 4];
            int n13 = n3;
            dArray7[n13] = dArray7[n13] * d;
        }
    }

    public static void dscalp_f77(int n, double d, double[] dArray, int n2) {
        if (n <= 0) {
            return;
        }
        int n3 = n % 5;
        int n4 = n3 + n2;
        int n5 = n2 + n - 1;
        int n6 = n2;
        while (n6 < n4) {
            int n7 = n6++;
            dArray[n7] = dArray[n7] * d;
        }
        for (n6 = n4; n6 <= n5; n6 += 5) {
            int n8 = n6;
            dArray[n8] = dArray[n8] * d;
            int n9 = n6 + 1;
            dArray[n9] = dArray[n9] * d;
            int n10 = n6 + 2;
            dArray[n10] = dArray[n10] * d;
            int n11 = n6 + 3;
            dArray[n11] = dArray[n11] * d;
            int n12 = n6 + 4;
            dArray[n12] = dArray[n12] * d;
        }
    }

    public static void colswap_f77(int n, double[][] dArray, int n2, int n3) {
        double d;
        int n4;
        if (n <= 0) {
            return;
        }
        int n5 = n % 3;
        for (n4 = 1; n4 <= n5; ++n4) {
            d = dArray[n4][n2];
            dArray[n4][n2] = dArray[n4][n3];
            dArray[n4][n3] = d;
        }
        for (n4 = n5 + 1; n4 <= n; n4 += 3) {
            d = dArray[n4][n2];
            dArray[n4][n2] = dArray[n4][n3];
            dArray[n4][n3] = d;
            d = dArray[n4 + 1][n2];
            dArray[n4 + 1][n2] = dArray[n4 + 1][n3];
            dArray[n4 + 1][n3] = d;
            d = dArray[n4 + 2][n2];
            dArray[n4 + 2][n2] = dArray[n4 + 2][n3];
            dArray[n4 + 2][n3] = d;
        }
    }

    public static double colnrm2_f77(int n, double[][] dArray, int n2, int n3) {
        double d;
        if (n < 1) {
            d = 0.0;
        } else if (n == 1) {
            d = Math.abs(dArray[n2][n3]);
        } else {
            double d2 = 0.0;
            double d3 = 1.0;
            int n4 = n2 + n - 1;
            for (int i = n2; i <= n4; ++i) {
                double d4;
                if (dArray[i][n3] == 0.0) continue;
                double d5 = Math.abs(dArray[i][n3]);
                if (d2 < d5) {
                    d4 = d2 / d5;
                    d3 = 1.0 + d3 * d4 * d4;
                    d2 = d5;
                    continue;
                }
                d4 = d5 / d2;
                d3 += d4 * d4;
            }
            d = d2 * Math.sqrt(d3);
        }
        return d;
    }

    public static double dnrm2p_f77(int n, double[] dArray, int n2) {
        double d;
        if (n < 1) {
            d = 0.0;
        } else if (n == 1) {
            d = Math.abs(dArray[n2]);
        } else {
            double d2 = 0.0;
            double d3 = 1.0;
            int n3 = n2 + n - 1;
            for (int i = n2; i <= n3; ++i) {
                double d4;
                if (dArray[i] == 0.0) continue;
                double d5 = Math.abs(dArray[i]);
                if (d2 < d5) {
                    d4 = d2 / d5;
                    d3 = 1.0 + d3 * d4 * d4;
                    d2 = d5;
                    continue;
                }
                d4 = d5 / d2;
                d3 += d4 * d4;
            }
            d = d2 * Math.sqrt(d3);
        }
        return d;
    }

    public static void dcopyp_f77(int n, double[] dArray, double[] dArray2, int n2) {
        int n3;
        int n4 = n % 7;
        int n5 = n4 + n2;
        int n6 = n2 + n - 1;
        for (n3 = n2; n3 < n5; ++n3) {
            dArray2[n3] = dArray[n3];
        }
        for (n3 = n5; n3 <= n6; n3 += 7) {
            dArray2[n3] = dArray[n3];
            dArray2[n3 + 1] = dArray[n3 + 1];
            dArray2[n3 + 2] = dArray[n3 + 2];
            dArray2[n3 + 3] = dArray[n3 + 3];
            dArray2[n3 + 4] = dArray[n3 + 4];
            dArray2[n3 + 5] = dArray[n3 + 5];
            dArray2[n3 + 6] = dArray[n3 + 6];
        }
    }

    public static void colrot_f77(int n, double[][] dArray, int n2, int n3, double d, double d2) {
        if (n <= 0) {
            return;
        }
        for (int i = 1; i <= n; ++i) {
            double d3 = d * dArray[i][n2] + d2 * dArray[i][n3];
            dArray[i][n3] = d * dArray[i][n3] - d2 * dArray[i][n2];
            dArray[i][n2] = d3;
        }
    }

    public static double sign_f77(double d, double d2) {
        if (d2 < 0.0) {
            return -Math.abs(d);
        }
        return Math.abs(d);
    }

    public static void matmat_f77(double[][] dArray, double[][] dArray2, double[][] dArray3, int n, int n2, int n3) {
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n3; ++j) {
                int n4;
                double d = 0.0;
                int n5 = n2 % 5;
                for (n4 = 1; n4 <= n5; ++n4) {
                    d += dArray[i][n4] * dArray2[n4][j];
                }
                for (n4 = n5 + 1; n4 <= n2; n4 += 5) {
                    d += dArray[i][n4] * dArray2[n4][j] + dArray[i][n4 + 1] * dArray2[n4 + 1][j] + dArray[i][n4 + 2] * dArray2[n4 + 2][j] + dArray[i][n4 + 3] * dArray2[n4 + 3][j] + dArray[i][n4 + 4] * dArray2[n4 + 4][j];
                }
                dArray3[i][j] = d;
            }
        }
    }

    public static void mattran_f77(double[][] dArray, double[][] dArray2, int n, int n2) {
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
    }

    public static void matvec_f77(double[][] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        for (int i = 1; i <= n; ++i) {
            int n3;
            double d = 0.0;
            int n4 = n2 % 5;
            for (n3 = 1; n3 <= n4; ++n3) {
                d += dArray[i][n3] * dArray2[n3];
            }
            for (n3 = n4 + 1; n3 <= n2; n3 += 5) {
                d += dArray[i][n3] * dArray2[n3] + dArray[i][n3 + 1] * dArray2[n3 + 1] + dArray[i][n3 + 2] * dArray2[n3 + 2] + dArray[i][n3 + 3] * dArray2[n3 + 3] + dArray[i][n3 + 4] * dArray2[n3 + 4];
            }
            dArray3[i] = d;
        }
    }
}

