/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath;

import org.planx.xmlstore.docnodes.DocAttribute;
import org.planx.xmlstore.docnodes.DocNode;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

public class XMLStoreNavigator
implements Navigator {
    @Override
    public Object getRoot(Object node) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).getRoot();
        }
        if (node instanceof DocAttribute) {
            return ((DocAttribute)node).getOwner().getRoot();
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public Object getParent(Object node) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).getParent();
        }
        if (node instanceof DocAttribute) {
            return ((DocAttribute)node).getOwner();
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public Object nextSibling(Object node) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).nextSibling();
        }
        if (node instanceof DocAttribute) {
            return null;
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public Object previousSibling(Object node) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).previousSibling();
        }
        if (node instanceof DocAttribute) {
            return null;
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public Object getChild(Object node, int index) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).getChild(index);
        }
        if (node instanceof DocAttribute) {
            return null;
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public int childCount(Object node) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).childCount();
        }
        if (node instanceof DocAttribute) {
            return 0;
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public Object getAttribute(Object node, int index) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).getAttribute(index);
        }
        if (node instanceof DocAttribute) {
            return null;
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public int attributeCount(Object node) throws XPathException {
        if (node instanceof DocNode) {
            return ((DocNode)node).attributeCount();
        }
        if (node instanceof DocAttribute) {
            return 0;
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public String getName(Object node) throws XPathException {
        if (node instanceof DocNode) {
            DocNode docNode = (DocNode)node;
            switch (docNode.getType()) {
                case 0: {
                    return docNode.getNodeValue();
                }
                case 1: {
                    return null;
                }
            }
            throw new RuntimeException("Unsupported type: " + docNode.getType());
        }
        if (node instanceof DocAttribute) {
            return ((DocAttribute)node).getName();
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    @Override
    public String getStringValue(Object node) throws XPathException {
        if (node instanceof DocAttribute) {
            return ((DocAttribute)node).getValue();
        }
        if (node instanceof DocNode) {
            StringBuffer sb = new StringBuffer();
            this.appendStringValue((DocNode)node, sb);
            return sb.toString();
        }
        throw new ClassCastException("Unknown object: " + node);
    }

    private void appendStringValue(DocNode node, StringBuffer sb) {
        switch (node.getType()) {
            case 0: {
                int max = node.childCount();
                for (int i = 0; i < max; ++i) {
                    this.appendStringValue(node.getChild(i), sb);
                }
                break;
            }
            case 1: {
                sb.append(node.getNodeValue());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type: " + node.getType());
            }
        }
    }

    @Override
    public int getType(Object node) throws XPathException {
        if (node instanceof DocNode) {
            DocNode docNode = (DocNode)node;
            switch (docNode.getType()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
            }
            throw new RuntimeException("Unsupported type: " + docNode.getType());
        }
        if (node instanceof DocAttribute) {
            return 4;
        }
        throw new ClassCastException("Unknown object: " + node);
    }
}

