/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath;

import java.util.HashMap;
import java.util.Map;
import org.planx.xpath.XPathException;
import org.planx.xpath.function.BooleanFunction;
import org.planx.xpath.function.Function;
import org.planx.xpath.function.LastFunction;
import org.planx.xpath.function.NumberFunction;
import org.planx.xpath.function.PositionFunction;
import org.planx.xpath.function.StringFunction;
import org.planx.xpath.object.XObject;

public class Environment {
    private Map functions = new HashMap();
    private Map variables = new HashMap();

    public Environment() {
        this.addCoreFunctions();
    }

    private void addCoreFunctions() {
        this.functions.put("boolean", new BooleanFunction());
        this.functions.put("number", new NumberFunction());
        this.functions.put("string", new StringFunction());
        this.functions.put("position", new PositionFunction());
        this.functions.put("last", new LastFunction());
    }

    public void bindFunction(String funcName, Function func) {
        this.functions.put(funcName, func);
    }

    public void bindFunctions(Map functions) {
        this.functions.putAll(functions);
    }

    public Function getFunction(String funcName) throws XPathException {
        if (this.functions.containsKey(funcName)) {
            return (Function)this.functions.get(funcName);
        }
        throw new XPathException("Function name not bound: " + funcName);
    }

    public void bindVariable(String varName, XObject value) {
        this.variables.put(varName, value);
    }

    public void bindVariables(Map variables) {
        this.variables.putAll(variables);
    }

    public XObject getVariable(String varName) throws XPathException {
        if (this.variables.containsKey(varName)) {
            return (XObject)this.variables.get(varName);
        }
        throw new XPathException("Variable name not bound: " + varName);
    }
}

