/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Concurrency {
    private static final int CORE_POOL_SIZE = 10;
    private static final int MAXIMUM_POOL_SIZE = 100;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static ExecutorService instance = null;

    private Concurrency() {
    }

    public static ExecutorService localExecutor() {
        if (instance == null) {
            instance = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return instance;
    }

    public static ExecutorService networkExecutor() {
        return Concurrency.localExecutor();
    }

    public static <V> Future<V> future(final V elm) {
        return new Future<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public V get() {
                return elm;
            }

            @Override
            public V get(long timeout, TimeUnit unit) {
                return elm;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };
    }
}

