/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.operation.OriginMessage;

public class NodeReplyMessage
extends OriginMessage {
    protected List nodes;

    protected NodeReplyMessage() {
    }

    public NodeReplyMessage(Node origin, List nodes) {
        super(origin);
        this.nodes = nodes;
    }

    public NodeReplyMessage(DataInput in) throws IOException {
        this.fromStream(in);
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        super.fromStream(in);
        int len = in.readByte();
        this.nodes = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            this.nodes.add(new Node(in));
        }
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        int len = this.nodes.size();
        if (len > 255) {
            throw new IndexOutOfBoundsException("Too many nodes in list: " + this.nodes.size());
        }
        out.writeByte((byte)len);
        for (int i = 0; i < len; ++i) {
            ((Node)this.nodes.get(i)).toStream(out);
        }
    }

    @Override
    public byte code() {
        return 4;
    }

    public List getNodes() {
        return this.nodes;
    }

    public String toString() {
        return "NodeReplyMessage[origin=" + this.origin + ",nodes=" + this.nodes + "]";
    }
}

