/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.routing.HashCalculator;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.messaging.UnknownMessageException;
import org.planx.xmlstore.routing.operation.HashMessage;
import org.planx.xmlstore.routing.operation.HashRequestMessage;
import org.planx.xmlstore.routing.operation.OriginReceiver;

public class HashRequestReceiver
extends OriginReceiver {
    private Map localMap;
    private HashCalculator hasher;

    public HashRequestReceiver(MessageServer server, Node local, Space space, Map localMap) {
        super(server, local, space);
        this.localMap = localMap;
        this.hasher = new HashCalculator(local, space, localMap);
    }

    @Override
    public void receive(Message incoming, int comm) throws IOException, UnknownMessageException {
        super.receive(incoming, comm);
        HashRequestMessage mess = (HashRequestMessage)incoming;
        Node origin = mess.getOrigin();
        long now = System.currentTimeMillis();
        List hashes = this.hasher.logarithmicHashes(origin, now);
        if (hashes.size() > 0) {
            HashMessage rep = new HashMessage(this.local, now, hashes);
            this.server.reply(comm, rep, origin.getInetAddress(), origin.getPort());
        }
    }
}

