/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.convert.XMLException;
import org.planx.xmlstore.nodes.DVMHandler;
import org.planx.xmlstore.nodes.NodeListener;
import org.planx.xmlstore.nodes.NodeProxy;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.nodes.XMLStoreNodeProxy;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final boolean useReader = true;
    private static XMLReader parser;
    private static SAXParser saxParser;

    private SAXBuilder() {
    }

    public static Node build(String fileName) throws XMLException, IOException {
        return SAXBuilder.build(fileName, (NodeListener)new DefaultListener());
    }

    public static Node build(String fileName, XMLStore xmlstore) throws XMLException, IOException {
        return SAXBuilder.build(fileName, (NodeListener)new XMLStoreNodeListener(xmlstore));
    }

    public static Node build(String fileName, XMLStore xmlstore, int flushDepth) throws XMLException, IOException {
        return SAXBuilder.build(fileName, (NodeListener)new XMLStoreNodeListener(xmlstore, flushDepth));
    }

    public static Node build(String fileName, NodeListener listener) throws XMLException, IOException {
        DVMHandler handler = null;
        InputStream in = null;
        try {
            handler = new DVMHandler(listener);
            parser.setContentHandler(handler);
            parser.parse(fileName);
            SystemNode n = handler.getRoot();
            handler.clear();
            handler = null;
            SystemNode systemNode = n;
            return systemNode;
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
        finally {
            if (handler != null) {
                handler.clear();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static Node build(InputSource in) throws XMLException, IOException {
        return SAXBuilder.build(in, (NodeListener)new DefaultListener());
    }

    public static Node build(InputSource in, XMLStore xmlstore) throws XMLException, IOException {
        return SAXBuilder.build(in, (NodeListener)new XMLStoreNodeListener(xmlstore));
    }

    public static Node build(InputSource in, NodeListener listener) throws XMLException, IOException {
        DVMHandler handler = null;
        try {
            handler = new DVMHandler(listener);
            parser.setContentHandler(handler);
            parser.parse(in);
            SystemNode n = handler.getRoot();
            handler.clear();
            handler = null;
            SystemNode systemNode = n;
            return systemNode;
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
        finally {
            if (handler != null) {
                handler.clear();
            }
        }
    }

    static {
        try {
            parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        catch (SAXException e1) {
            try {
                parser = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new NoClassDefFoundError("No SAX parser is available: " + e2);
            }
        }
    }

    private static class XMLStoreNodeListener
    implements NodeListener {
        private XMLStore xmlstore;
        private int flushDepth;

        XMLStoreNodeListener(XMLStore xmlstore) {
            this(xmlstore, 1);
        }

        XMLStoreNodeListener(XMLStore xmlstore, int flushDepth) {
            this.xmlstore = xmlstore;
            this.flushDepth = flushDepth;
        }

        @Override
        public SystemNode nodeCreated(SystemNode node, int depth) {
            if (depth <= this.flushDepth) {
                try {
                    Reference ref = this.xmlstore.save(node);
                    List<SystemNode> children = node.getChildren();
                    int max = children.size();
                    for (int i = 0; i < max; ++i) {
                        SystemNode child = children.get(i);
                        if (!(child instanceof NodeProxy)) continue;
                        ((NodeProxy)child).unload();
                    }
                    return new XMLStoreNodeProxy(ref, this.xmlstore);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return node;
        }
    }

    private static class DefaultListener
    implements NodeListener {
        private DefaultListener() {
        }

        @Override
        public SystemNode nodeCreated(SystemNode node, int depth) {
            return node;
        }
    }
}

