/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.util.Association;
import org.planx.util.Pair;

public final class WeakSorter {
    private WeakSorter() {
    }

    public static <U, E, S> List<Pair<List<E>, S>> sortLists(Discriminator<E> d, List<? extends U> values, Extractor<U, ? extends List<E>, S> e, boolean doRemoveDuplicates) {
        int insize = values.size();
        ArrayList<IWrap<E>> in = new ArrayList<IWrap<E>>();
        Pair[] sorted = new Pair[insize];
        for (int i = 0; i < insize; ++i) {
            U elm = values.get(i);
            List<E> list = e.getLabel(elm);
            for (E t : list) {
                in.add(new IWrap<E>(t, i));
            }
            ArrayList newList = new ArrayList(list.size());
            S value = e.getValue(elm);
            sorted[i] = new Association(newList, value);
        }
        Extractor ext = new Extractor<IWrap<E>, E, IWrap<E>>(){

            @Override
            public E getLabel(IWrap<E> elm) {
                return elm.obj;
            }

            @Override
            public IWrap<E> getValue(IWrap<E> elm) {
                return elm;
            }
        };
        Collection order = d.discriminate(in, ext);
        for (List group : order) {
            int prevIdx = -1;
            for (IWrap wrap : group) {
                int idx = wrap.i;
                if (!doRemoveDuplicates || doRemoveDuplicates && idx != prevIdx) {
                    Pair p = sorted[idx];
                    List list = (List)p.getFirst();
                    list.add(wrap.obj);
                }
                prevIdx = idx;
            }
        }
        List<Pair<List<E>, S>> result = Arrays.asList(sorted);
        return result;
    }

    public static <E> void sort(Discriminator<E> d, List<? extends List<E>> values) {
        Extractor e = Discriminators.identityExtractor();
        WeakSorter.sort(d, values, e);
    }

    public static <U, E> void sort(Discriminator<E> d, List<? extends U> values, Extractor<U, ? extends List<E>, ?> e) {
        ArrayList<IWrap<E>> in = new ArrayList<IWrap<E>>();
        int insize = values.size();
        for (int i = 0; i < insize; ++i) {
            List<E> list = e.getLabel(values.get(i));
            for (E elm : list) {
                in.add(new IWrap<E>(elm, i));
            }
        }
        Extractor ext = new Extractor<IWrap<E>, E, IWrap<E>>(){

            @Override
            public E getLabel(IWrap<E> elm) {
                return elm.obj;
            }

            @Override
            public IWrap<E> getValue(IWrap<E> elm) {
                return elm;
            }
        };
        Collection order = d.discriminate(in, ext);
        int[] cursors = new int[insize];
        for (List group : order) {
            for (IWrap wrap : group) {
                int pos;
                int idx = wrap.i;
                List list = e.getLabel(values.get(idx));
                int n = idx;
                cursors[n] = cursors[n] + 1;
                list.set(pos, wrap.obj);
            }
        }
    }

    private static class IWrap<E> {
        E obj;
        int i;

        public IWrap(E obj, int i) {
            this.obj = obj;
            this.i = i;
        }
    }
}

