/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Extractor;
import org.planx.util.Array;
import org.planx.util.Pair;

public final class Discriminators {
    private static final Extractor<Object, Object, Object> IDENTITY_EXTRACTOR = new Extractor<Object, Object, Object>(){

        @Override
        public Object getLabel(Object elm) {
            return elm;
        }

        @Override
        public Object getValue(Object elm) {
            return elm;
        }
    };
    private static final Extractor<Pair<Object, Object>, Object, Object> PAIR_EXTRACTOR = new Extractor<Pair<Object, Object>, Object, Object>(){

        @Override
        public Object getLabel(Pair<Object, Object> elm) {
            return elm.getFirst();
        }

        @Override
        public Object getValue(Pair<Object, Object> elm) {
            return elm.getSecond();
        }
    };
    private static final Extractor<Pair<Object, Object>, Object, Object> PAIR_FLIP_EXTRACTOR = new Extractor<Pair<Object, Object>, Object, Object>(){

        @Override
        public Object getLabel(Pair<Object, Object> elm) {
            return elm.getSecond();
        }

        @Override
        public Object getValue(Pair<Object, Object> elm) {
            return elm.getFirst();
        }
    };
    private static final Extractor<Pair<Object, Object>, Object, Pair<Object, Object>> PAIR_FIRST_EXTRACTOR = new Extractor<Pair<Object, Object>, Object, Pair<Object, Object>>(){

        @Override
        public Object getLabel(Pair<Object, Object> elm) {
            return elm.getFirst();
        }

        @Override
        public Pair<Object, Object> getValue(Pair<Object, Object> elm) {
            return elm;
        }
    };
    private static final Extractor<Pair<Object, Object>, Object, Pair<Object, Object>> PAIR_SECOND_EXTRACTOR = new Extractor<Pair<Object, Object>, Object, Pair<Object, Object>>(){

        @Override
        public Object getLabel(Pair<Object, Object> elm) {
            return elm.getSecond();
        }

        @Override
        public Pair<Object, Object> getValue(Pair<Object, Object> elm) {
            return elm;
        }
    };
    private static final int INIT_CAPACITY = 10;

    public static <E> boolean equals(E o1, E o2, Discriminator<E> d) {
        List<Object> twoElms = Arrays.asList(o1, o2);
        Collection<List<Object>> eqs = d.discriminate(twoElms);
        return eqs.size() != 1;
    }

    public static boolean equals(CharSequence c1, CharSequence c2) {
        if (c1 == c2) {
            return true;
        }
        int n = c1.length();
        if (n != c2.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (c1.charAt(i) == c2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static <T> Extractor<T, T, T> identityExtractor() {
        return IDENTITY_EXTRACTOR;
    }

    public static <U, T> Extractor<U, T, U> identityExtractor(final Extractor<U, T, ?> e) {
        return new Extractor<U, T, U>(){

            @Override
            public T getLabel(U elm) {
                return e.getLabel(elm);
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
    }

    public static <T, S, P extends Pair<T, S>> Extractor<P, T, S> pairExtractor() {
        return PAIR_EXTRACTOR;
    }

    public static <T, S, P extends Pair<T, S>> Extractor<P, S, T> pairFlipExtractor() {
        return PAIR_FLIP_EXTRACTOR;
    }

    public static <T, P extends Pair<T, ?>> Extractor<P, T, P> pairFirstExtractor() {
        return PAIR_FIRST_EXTRACTOR;
    }

    public static <S, P extends Pair<?, S>> Extractor<P, S, P> pairSecondExtractor() {
        return PAIR_SECOND_EXTRACTOR;
    }

    public static <U, S> List<S> valueList(List<? extends U> list, Extractor<U, ?, S> e) {
        return new ValueList<U, S>(list, e);
    }

    public static <U, S, A, B> Collection<List<S>> discriminate(List<? extends U> values, Discriminator<A> d1, Extractor<U, ? extends A, U> e1, Discriminator<B> d2, Extractor<U, ? extends B, S> e2) {
        Discriminator[] ds = new Discriminator[]{d1, d2};
        Extractor[] es = new Extractor[]{e1, e2};
        return Discriminators.discriminate(values, ds, es);
    }

    public static <U, S, A, B, C> Collection<List<S>> discriminate(List<? extends U> values, Discriminator<A> d1, Extractor<U, ? extends A, U> e1, Discriminator<B> d2, Extractor<U, ? extends B, U> e2, Discriminator<C> d3, Extractor<U, ? extends C, S> e3) {
        Discriminator[] ds = new Discriminator[]{d1, d2, d3};
        Extractor[] es = new Extractor[]{e1, e2, e3};
        return Discriminators.discriminate(values, ds, es);
    }

    public static <U, S, A, B, C, D> Collection<List<S>> discriminate(List<? extends U> values, Discriminator<A> d1, Extractor<U, ? extends A, U> e1, Discriminator<B> d2, Extractor<U, ? extends B, U> e2, Discriminator<C> d3, Extractor<U, ? extends C, U> e3, Discriminator<D> d4, Extractor<U, ? extends D, S> e4) {
        Discriminator[] ds = new Discriminator[]{d1, d2, d3, d4};
        Extractor[] es = new Extractor[]{e1, e2, e3, e4};
        return Discriminators.discriminate(values, ds, es);
    }

    static <U, S> Collection<List<S>> discriminate(List<? extends U> values, Discriminator[] ds, Extractor[] es) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        int[] indexes = new int[10];
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 1;
        work[0] = values;
        while (work_head > 0) {
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            List block = work[--work_head];
            int blockSize = block.size();
            int index = indexes[work_head];
            if (ds.length > index + 1) {
                Collection partition = ds[index].discriminate(block, es[index]);
                ++index;
                for (List subBlock : partition) {
                    if (subBlock.size() > 1) {
                        if (work_head + 1 >= work_capacity) {
                            work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                            indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                            work_capacity = work.length;
                        }
                        work[work_head] = subBlock;
                        indexes[work_head] = index;
                        ++work_head;
                        continue;
                    }
                    result.add(Discriminators.valueList(subBlock, es[es.length - 1]));
                }
                continue;
            }
            Collection lastPartition = ds[index].discriminate(block, es[index]);
            result.addAll(lastPartition);
        }
        return result;
    }

    private static class ValueList<U, S>
    extends AbstractList<S> {
        private final List<? extends U> list;
        private final Extractor<U, ?, S> e;

        ValueList(List<? extends U> list, Extractor<U, ?, S> e) {
            this.list = list;
            this.e = e;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public S get(int index) {
            return this.e.getValue(this.list.get(index));
        }
    }
}

