package org.planx.xmlstore.nodes;

import java.io.IOException;
import org.planx.xmlstore.*;
import org.planx.xmlstore.io.LocalLocator;

/**
 * @author Thomas Ambus
 */
public class XMLStoreNodeProxy extends NodeProxy {
    protected XMLStore xmlstore;

    public XMLStoreNodeProxy(Reference ref, XMLStore xmlstore) {
        super(ref);
        this.xmlstore = xmlstore;
    }

    public XMLStoreNodeProxy(LocalLocator loc, Reference ref, XMLStore xmlstore) {
        super(loc, ref);
        this.xmlstore = xmlstore;
    }

    protected SystemNode generate() throws UnknownReferenceException, IOException {
        LocalLocator l = null;
        try {
            l = getLocator();
            if (l != null) return (SystemNode) xmlstore.load(l);
        } catch (UnknownReferenceException e) {
            if (ref == l) throw e;
        }
        return (SystemNode) xmlstore.load(ref);
    }
}
