package org.planx.util;

import java.util.*;

public class LookupHashSet<E> extends AbstractSet<E> implements Set<E> {
    private transient HashMap<E,E> map;

    public LookupHashSet() {
        map = new HashMap<E,E>();
    }

    public LookupHashSet(Collection<? extends E> c) {
        map = new HashMap<E,E>(Math.max((int) (c.size()/.75f) + 1, 16));
        addAll(c);
    }

    public LookupHashSet(int initialCapacity, float loadFactor) {
        map = new HashMap<E,E>(initialCapacity, loadFactor);
    }

    public LookupHashSet(int initialCapacity) {
        map = new HashMap<E,E>(initialCapacity);
    }

    public E get(Object o) {
        return map.get(o);
    }

    public Iterator<E> iterator() {
        return map.keySet().iterator();
    }

    public int size() {
        return map.size();
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public boolean contains(Object o) {
        return map.containsKey(o);
    }

    public boolean add(E o) {
        return map.put(o, o) == null;
    }

    public boolean remove(Object o) {
        return map.remove(o) != null;
    }

    public void clear() {
        map.clear();
    }
}
