package org.planx.msd.number;

import java.util.AbstractList;
import java.util.List;
import org.planx.msd.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Long</code> objects.
 *
 * @author Thomas Ambus
 */
public class LongDiscriminator extends NumberDiscriminator<Long> {
    public LongDiscriminator(Memory memory) {super(memory);}

    protected int bitsize() {return 64;}

    protected <U> ChunkExtractor<U> chunkExtractor(
                        Extractor<U,? extends Long,?> e) {
        return new ChunkExtractor<U>(e) {
            public int getLabel(U elm) {
                Long value = e.getLabel(elm);
                return (int) ((value.longValue() >> offset) & CHUNK_MASK);
            }
        };
    }
}
