/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.object;

import org.planx.xpath.object.XSimple;

public class XNumber
extends XSimple {
    public static final XNumber NaN = new XNumber(Double.NaN);
    private final Double value;

    public XNumber(double value) {
        this(new Double(value));
    }

    public XNumber(Double value) {
        this.value = value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public long longValue() {
        return this.value.longValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public boolean booleanValue() {
        double value = this.doubleValue();
        return !Double.isNaN(value) && value != 0.0;
    }

    @Override
    public String stringValue() {
        long lngValue = this.longValue();
        if (this.doubleValue() == (double)lngValue) {
            return Long.toString(lngValue);
        }
        return this.value.toString();
    }

    public String toString() {
        return this.stringValue();
    }

    public boolean equals(Object o) {
        if (o instanceof XNumber) {
            XNumber other = (XNumber)o;
            return this.doubleValue() == other.doubleValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

