/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.operator;

import java.util.Collection;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.operator.Operator;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XObject;

public class UnionOperator
extends Operator {
    public UnionOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    @Override
    protected XObject evaluate(XObject o1, XObject o2, Navigator navigator) throws XPathException {
        XNodeSet set1 = null;
        XNodeSet set2 = null;
        try {
            set1 = (XNodeSet)o1;
            set2 = (XNodeSet)o2;
            set1.addAll((Collection)set2);
            return set1;
        }
        catch (ClassCastException e) {
            String err = "Expression did not evaluate to an XNodeSet: ";
            if (set1 == null) {
                throw new XPathException(err + this.e1);
            }
            if (set2 == null) {
                throw new XPathException(err + this.e2);
            }
            throw e;
        }
    }

    @Override
    protected String operatorName() {
        return "|";
    }
}

