/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.operator;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.operator.Operator;
import org.planx.xpath.object.XBoolean;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XNumber;
import org.planx.xpath.object.XObject;
import org.planx.xpath.object.XSimple;
import org.planx.xpath.object.XString;

public abstract class EqualityOperator
extends Operator {
    public EqualityOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    @Override
    protected XObject evaluate(XObject o1, XObject o2, Navigator navigator) throws XPathException {
        boolean result;
        if (o1 instanceof XBoolean || o2 instanceof XBoolean) {
            result = this.compare(o1.booleanValue(), o2.booleanValue());
        } else if (o1 instanceof XNodeSet && o2 instanceof XNodeSet) {
            result = this.compare((XNodeSet)o1, (XNodeSet)o2, navigator);
        } else if (o1 instanceof XNodeSet && o2 instanceof XSimple) {
            result = this.compare((XNodeSet)o1, (XSimple)o2, navigator);
        } else if (o1 instanceof XSimple && o2 instanceof XNodeSet) {
            result = this.compare((XNodeSet)o2, (XSimple)o1, navigator);
        } else if (o1 instanceof XNumber || o2 instanceof XNumber) {
            result = this.compare(((XSimple)o1).doubleValue(), ((XSimple)o2).doubleValue());
        } else if (o1 instanceof XString && o2 instanceof XString) {
            result = this.compare(((XSimple)o1).stringValue(), ((XSimple)o2).stringValue());
        } else {
            throw new XPathException("Unsupported subclass of XObject");
        }
        return result ? XBoolean.TRUE : XBoolean.FALSE;
    }

    private boolean compare(XNodeSet o1, XSimple o2, Navigator navigator) throws XPathException {
        block3: {
            block2: {
                if (!(o2 instanceof XNumber)) break block2;
                double v2 = o2.doubleValue();
                int size = o1.size();
                for (int i = 0; i < size; ++i) {
                    String s1 = navigator.getStringValue(o1.get(i));
                    double v1 = XString.doubleValue(s1);
                    if (!this.compare(v1, v2)) continue;
                    return true;
                }
                break block3;
            }
            if (!(o2 instanceof XString)) break block3;
            String v2 = o2.stringValue();
            int size = o1.size();
            for (int i = 0; i < size; ++i) {
                String v1 = navigator.getStringValue(o1.get(i));
                if (!this.compare(v1, v2)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean compare(XNodeSet var1, XNodeSet var2, Navigator var3) throws XPathException;

    protected abstract boolean compare(boolean var1, boolean var2);

    protected abstract boolean compare(double var1, double var3);

    protected abstract boolean compare(String var1, String var2);
}

