/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.routing.HashCalculator;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.TimestampedEntry;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.OriginReceiver;
import org.planx.xmlstore.routing.operation.StoreMessage;
import org.planx.xmlstore.routing.operation.StoreRequestMessage;

public class StoreRequestReceiver
extends OriginReceiver {
    private Map localMap;
    private HashCalculator hasher;

    public StoreRequestReceiver(MessageServer server, Node local, Space space, Map localMap) {
        super(server, local, space);
        this.localMap = localMap;
        this.hasher = new HashCalculator(local, space, localMap);
    }

    @Override
    public void receive(Message incoming, int comm) throws IOException {
        super.receive(incoming, comm);
        StoreRequestMessage mess = (StoreRequestMessage)incoming;
        Node origin = mess.getOrigin();
        List mappings = this.hasher.mappingsBetween(origin, mess.getBegin(), mess.getEnd());
        int max = mappings.size();
        for (int i = 0; i < max; ++i) {
            TimestampedEntry entry = (TimestampedEntry)mappings.get(i);
            StoreMessage rep = new StoreMessage(this.local, entry.getKey(), entry.getValue(), true);
            this.server.send(rep, origin.getInetAddress(), origin.getPort(), null);
        }
    }
}

