/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.util.Comparator;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.TimestampedValue;

public class TimestampedEntry {
    static final TimestampComparator TIMESTAMP_COMPARATOR = new TimestampComparator();
    private final Identifier key;
    private final TimestampedValue value;

    public TimestampedEntry(Identifier key, TimestampedValue value) {
        this.key = key;
        this.value = value;
    }

    public Identifier getKey() {
        return this.key;
    }

    public TimestampedValue getValue() {
        return this.value;
    }

    public String toString() {
        return "{key=" + this.key + ",value=" + this.value + "}";
    }

    static class TimestampComparator
    implements Comparator {
        TimestampComparator() {
        }

        public int compare(Object o1, Object o2) {
            return (int)(this.longValue(o1) - this.longValue(o2));
        }

        private long longValue(Object o) {
            if (o instanceof TimestampedEntry) {
                return ((TimestampedEntry)o).value.timestamp();
            }
            if (o instanceof Long) {
                return (Long)o;
            }
            throw new ClassCastException("Cannot compare to" + o.getClass());
        }
    }
}

