/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import org.planx.xmlstore.regions.CanonicPolicy;

public class RegionConfiguration {
    public static final int POLICY_FIRST = 1;
    public static final int POLICY_LEAST_INTER_REGION = 2;
    public int REGION_SIZE = 0x100000;
    public int CACHE_SIZE = 10;
    public boolean USE_HASH_SHARER = false;
    public boolean DO_SHARE_NEW = true;
    public boolean ENABLE_SHARER = true;
    public long SHARER_PERIOD = 10000L;
    public CanonicPolicy POLICY_INSTANCE = null;
    public int POLICY = 2;

    public static RegionConfiguration environmentConfiguration() {
        RegionConfiguration conf = new RegionConfiguration();
        conf.REGION_SIZE = RegionConfiguration.getInt("REGION_SIZE", conf.REGION_SIZE);
        conf.CACHE_SIZE = RegionConfiguration.getInt("CACHE_SIZE", conf.CACHE_SIZE);
        conf.USE_HASH_SHARER = RegionConfiguration.getBoolean("USE_HASH_SHARER", conf.USE_HASH_SHARER);
        conf.DO_SHARE_NEW = RegionConfiguration.getBoolean("DO_SHARE_NEW", conf.DO_SHARE_NEW);
        conf.ENABLE_SHARER = RegionConfiguration.getBoolean("ENABLE_SHARER", conf.ENABLE_SHARER);
        conf.SHARER_PERIOD = RegionConfiguration.getLong("SHARER_PERIOD", conf.SHARER_PERIOD);
        conf.POLICY = RegionConfiguration.getInt("POLICY", conf.POLICY);
        return conf;
    }

    private static int getInt(String name, int d) {
        String p = RegionConfiguration.getProperty(name);
        return p == null ? d : Integer.parseInt(p);
    }

    private static long getLong(String name, long d) {
        String p = RegionConfiguration.getProperty(name);
        return p == null ? d : Long.parseLong(p);
    }

    private static boolean getBoolean(String name, boolean d) {
        String p = RegionConfiguration.getProperty(name);
        return p == null ? d : Boolean.parseBoolean(p);
    }

    private static String getProperty(String name) {
        String p = System.getenv(name);
        return p == null ? null : (p.length() == 0 ? null : p);
    }

    public String toString() {
        return "RegionConfiguration\n  REGION_SIZE     = " + this.REGION_SIZE + "\n" + "  CACHE_SIZE      = " + this.CACHE_SIZE + "\n" + "  USE_HASH_SHARER = " + this.USE_HASH_SHARER + "\n" + "  DO_SHARE_NEW    = " + this.DO_SHARE_NEW + "\n" + "  ENABLE_SHARER   = " + this.ENABLE_SHARER + "\n" + "  SHARER_PERIOD   = " + this.SHARER_PERIOD + "\n" + "  POLICY_INSTANCE = " + (this.POLICY_INSTANCE == null ? "null" : this.POLICY_INSTANCE.getClass().getName()) + "\n";
    }
}

