/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.nodes.DVMAttribute;
import org.planx.xmlstore.nodes.DVMNode;
import org.planx.xmlstore.nodes.SystemNode;

public class InlineNodeStreamer
implements Streamer<Node> {
    private static Streamer<Attribute> attrStreamer = DVMAttribute.getStreamer();

    @Override
    public void toStream(DataOutput out, Node node) throws IOException {
        byte type = node.getType();
        out.writeByte(type);
        Streamers.writeUTF(out, node.getNodeValue());
        if (type == 0) {
            Streamers.writeList(out, node.getAttributes(), attrStreamer);
            List<? extends Node> children = node.getChildren();
            Streamers.writeShortInt(out, children.size());
            for (Node node2 : children) {
                this.toStream(out, node2);
            }
        }
    }

    @Override
    public SystemNode fromStream(DataInput in) throws IOException {
        byte type = in.readByte();
        String value = Streamers.readUTF(in);
        List<Attribute> attributes = null;
        ArrayList<SystemNode> children = null;
        if (type == 0) {
            attributes = Streamers.readList(in, attrStreamer);
            int size = Streamers.readShortInt(in);
            children = new ArrayList<SystemNode>(size);
            for (int i = 0; i < size; ++i) {
                SystemNode n = this.fromStream(in);
                children.add(n);
            }
        }
        return new DVMNode(type, value, children, attributes, null, false);
    }
}

