/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.docnodes;

import java.util.ArrayList;
import java.util.List;
import org.planx.util.Array;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.docnodes.DocAttribute;

public class DocNode
implements Node {
    private Node node;
    private DocNode parent;
    private int childIndex;
    private DocNode root;
    private List<DocNode> docChildren = null;
    private List<DocAttribute> docAttributes = null;

    public DocNode(Node node) {
        this.node = node;
        this.parent = null;
        this.childIndex = -1;
        this.root = this;
    }

    DocNode(Node node, DocNode parent, int childIndex, DocNode root) {
        this.node = node;
        this.parent = parent;
        this.childIndex = childIndex;
        this.root = root;
    }

    public int[] getPath() {
        ArrayList path = new ArrayList();
        this.makePath(path);
        int length = path.size();
        int[] a = new int[length];
        for (int i = 0; i < length; ++i) {
            a[i] = (Integer)path.get(i);
        }
        return a;
    }

    private void makePath(List path) {
        if (this.parent != null) {
            this.parent.makePath(path);
            path.add(new Integer(this.childIndex));
        }
    }

    public DocNode getRoot() {
        return this.root;
    }

    public DocNode getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.childIndex;
    }

    public DocNode getChild(int index) {
        return this.getDocChildren().get(index);
    }

    public int childCount() {
        return this.getDocChildren().size();
    }

    public List<DocNode> getDocChildren() {
        if (this.docChildren == null) {
            List<? extends Node> children = this.node.getChildren();
            DocNode[] dn = new DocNode[children.size()];
            int max = children.size();
            for (int i = 0; i < max; ++i) {
                dn[i] = new DocNode(children.get(i), this, i, this.root);
            }
            this.docChildren = Array.asUnmodifiableList(dn);
        }
        return this.docChildren;
    }

    public DocNode nextSibling() {
        if (this.parent == null) {
            return null;
        }
        List<DocNode> siblings = this.parent.getDocChildren();
        if (siblings.size() > this.childIndex + 1) {
            return siblings.get(this.childIndex + 1);
        }
        return null;
    }

    public DocNode previousSibling() {
        if (this.parent == null) {
            return null;
        }
        List<DocNode> siblings = this.parent.getDocChildren();
        if (this.childIndex - 1 >= 0) {
            return siblings.get(this.childIndex - 1);
        }
        return null;
    }

    public int attributeCount() {
        return this.getDocAttributes().size();
    }

    public DocAttribute getAttribute(int index) {
        return this.getDocAttributes().get(index);
    }

    public List<DocAttribute> getDocAttributes() {
        if (this.docAttributes == null) {
            List<Attribute> attributes = this.node.getAttributes();
            DocAttribute[] dn = new DocAttribute[attributes.size()];
            int max = attributes.size();
            for (int i = 0; i < max; ++i) {
                Attribute attr = attributes.get(i);
                dn[i] = new DocAttribute(attr, this);
            }
            this.docAttributes = Array.asUnmodifiableList(dn);
        }
        return this.docAttributes;
    }

    @Override
    public boolean isMutable() {
        return this.node.isMutable();
    }

    @Override
    public byte getType() {
        return this.node.getType();
    }

    @Override
    public String getNodeValue() {
        return this.node.getNodeValue();
    }

    @Override
    public String getAttribute(String attrName) {
        return this.node.getAttribute(attrName);
    }

    @Override
    public String[] getAttributeNames() {
        return this.node.getAttributeNames();
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.node.getChildren();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.node.getAttributes();
    }

    public String toString() {
        return this.node.toString();
    }
}

