/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.convert;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.convert.DOMBuilder;
import org.planx.xmlstore.convert.DOMUtil;
import org.planx.xmlstore.convert.SAXBuilder;
import org.planx.xmlstore.convert.XMLException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DVMBuilder {
    private static SAXParser parser;
    private XMLStore xmlstore = null;

    public DVMBuilder(XMLStore xmlstore) {
        this.xmlstore = xmlstore;
    }

    public static Node parse(InputSource in) throws XMLException, IOException {
        Document doc = DOMUtil.parseSource(in);
        org.w3c.dom.Node root = doc.getDocumentElement();
        root = DOMUtil.removeEmptyTextNodes(root);
        return DOMBuilder.build(root);
    }

    public static Node parse(String fileName) throws XMLException, IOException {
        Document doc = DOMUtil.parseFile(fileName);
        org.w3c.dom.Node root = doc.getDocumentElement();
        root = DOMUtil.removeEmptyTextNodes(root);
        return DOMBuilder.build(root);
    }

    public Reference unparse(InputSource in) throws XMLException, IOException {
        Node node = SAXBuilder.build(in, this.xmlstore);
        return this.xmlstore.save(node);
    }

    public Reference unparse(String fileName) throws XMLException, IOException {
        Node node = SAXBuilder.build(fileName, this.xmlstore);
        return this.xmlstore.save(node);
    }

    public static Node saxparse(String fileName) throws XMLException, IOException {
        return SAXBuilder.build(fileName);
    }

    static {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

