/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.convert;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.planx.xmlstore.convert.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtil {
    public static Node removeEmptyTextNodes(Node node) {
        if (node.getNodeType() == 1) {
            NodeList children = node.getChildNodes();
            int length = children.getLength();
            block4: for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child == null) continue;
                switch (child.getNodeType()) {
                    case 1: {
                        node.replaceChild(DOMUtil.removeEmptyTextNodes(child), child);
                        continue block4;
                    }
                    case 3: {
                        if (child.getNodeValue().trim().length() != 0) continue block4;
                        node.removeChild(child);
                        --i;
                    }
                }
            }
        } else if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) {
            return null;
        }
        return node;
    }

    public static Document parseSource(InputSource in) throws XMLException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
    }

    public static Document parseFile(String filename) throws XMLException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new File(filename));
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
    }
}

