/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LookupHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private transient HashMap<E, E> map;

    public LookupHashSet() {
        this.map = new HashMap();
    }

    public LookupHashSet(Collection<? extends E> c) {
        this.map = new HashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public LookupHashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public LookupHashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public E get(Object o) {
        return this.map.get(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, o) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

