/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IndexSet<K, V>
implements Iterable<V> {
    HashMap<K, Set<V>> map = new HashMap();
    private int size = 0;

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            Iterator<Set<V>> it;
            Iterator<V> current;
            {
                this.it = IndexSet.this.map.values().iterator();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current != null && this.current.hasNext()) {
                    return true;
                }
                return this.it.hasNext();
            }

            @Override
            public V next() {
                if (this.current == null || !this.current.hasNext()) {
                    this.current = this.it.next().iterator();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.size;
    }

    public Set<V> get(K key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public void add(K key, V edge) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            set = new HashSet<V>(1);
        }
        int before = set.size();
        set.add(edge);
        if (set.size() > before) {
            ++this.size;
        }
        this.map.put(key, set);
    }

    public void remove(K key, V edge) {
        Set<V> set = this.map.get(key);
        if (set != null) {
            int before = set.size();
            set.remove(edge);
            int after = set.size();
            if (after < before) {
                --this.size;
            }
            if (after == 0) {
                this.map.remove(key);
            }
        }
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (V o : this) {
            if (!isFirst) {
                sb.append(',');
            }
            sb.append(o.toString());
            isFirst = false;
        }
        sb.append('}');
        return sb.toString();
    }
}

