/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.list;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.planx.msd.Discriminator;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.list.SizeRandomAccessListDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Association;

public class ListDiscriminator<T>
extends AbstractDiscriminator<List<T>> {
    private Discriminator<List<T>> disc;

    public ListDiscriminator(Discriminator<T> d, Memory memory) {
        this.disc = new SizeRandomAccessListDiscriminator<T>(d, memory);
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends List<T>, S> e) {
        boolean isRandomAccess = true;
        for (U elm : values) {
            if (e.getLabel(elm) instanceof RandomAccess) continue;
            isRandomAccess = false;
            break;
        }
        if (isRandomAccess) {
            return this.disc.discriminate(values, e);
        }
        ArrayList<Association<IteratorList<T>, S>> input = new ArrayList<Association<IteratorList<T>, S>>(values.size());
        for (U elm : values) {
            IteratorList<T> list = new IteratorList<T>(e.getLabel(elm));
            input.add(new Association<IteratorList<T>, S>(list, e.getValue(elm)));
        }
        Extractor ext = Discriminators.pairExtractor();
        return this.disc.discriminate(input, ext);
    }

    private static class IteratorList<E>
    extends AbstractList<E> {
        private List<E> list;
        private Iterator<E> iterator = null;
        private int itIndex = -1;
        private E current = null;

        IteratorList(List<E> list) {
            this.list = list;
        }

        public List<E> getList() {
            return this.list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                this.iterator = this.list.iterator();
                this.itIndex = 0;
                this.current = this.iterator.next();
                return this.current;
            }
            if (index == this.itIndex + 1 && this.iterator.hasNext()) {
                ++this.itIndex;
                this.current = this.iterator.next();
                return this.current;
            }
            if (index == this.itIndex) {
                return this.current;
            }
            return this.list.get(index);
        }
    }
}

