/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class PrecedingSiblingAxis
extends Axis {
    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new PrecedingSiblingAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return true;
    }

    public String toString() {
        return "preceding-sibling";
    }

    class PrecedingSiblingAxisIterator
    implements AxisIterator {
        private Object currentNode = null;
        private Navigator navigator;
        private XPathException currentException = null;

        PrecedingSiblingAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            this.navigator = navigator;
            int type = navigator.getType(contextNode);
            if (type != 4) {
                this.currentNode = contextNode;
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public Object next() throws XPathException {
            if (this.currentException != null) {
                throw this.currentException;
            }
            if (this.currentNode == null) {
                throw new XPathException("No more elements in iterator");
            }
            Object result = this.currentNode;
            try {
                this.currentNode = this.navigator.previousSibling(this.currentNode);
            }
            catch (XPathException e) {
                this.currentException = e;
                this.currentNode = null;
            }
            return result;
        }
    }
}

