/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.references.ReferenceProxy;
import org.planx.xmlstore.references.RelativeReference;

public abstract class AbstractXMLStore
implements XMLStore {
    protected XMLStore xmlstore;

    protected AbstractXMLStore() {
    }

    protected AbstractXMLStore(XMLStore xmlstore) {
        this.xmlstore = xmlstore;
    }

    @Override
    public void close() throws IOException {
        this.xmlstore.close();
        this.xmlstore = null;
    }

    protected void checkClosed() {
        if (this.xmlstore == null) {
            throw new IllegalStateException("XMLStore is closed");
        }
    }

    @Override
    public Reference save(Node node) throws IOException {
        this.checkClosed();
        return this.xmlstore.save(node);
    }

    @Override
    public Node load(Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        return this.loadResolve(vref);
    }

    private Node loadResolve(Reference vref) throws IOException, UnknownReferenceException {
        if (vref instanceof RelativeReference) {
            RelativeReference relRef = (RelativeReference)vref;
            Node root = this.load(relRef.getRoot());
            return AbstractXMLStore.findNode(root, relRef.getPath(), 0);
        }
        if (vref instanceof ReferenceProxy) {
            return this.loadResolve(((ReferenceProxy)vref).get());
        }
        return this.resolvedLoad(vref);
    }

    protected Node resolvedLoad(Reference resolvedRef) throws IOException, UnknownReferenceException {
        return this.xmlstore.load(resolvedRef);
    }

    private static Node findNode(Node node, int[] path, int pos) {
        if (pos >= path.length) {
            return node;
        }
        return AbstractXMLStore.findNode(node.getChildren().get(path[pos]), path, pos + 1);
    }

    public String toString() {
        return this.xmlstore.toString();
    }
}

