/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageFactory;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.messaging.Receiver;
import org.planx.xmlstore.routing.messaging.UnknownMessageException;
import org.planx.xmlstore.routing.operation.AcknowledgeMessage;
import org.planx.xmlstore.routing.operation.ConnectMessage;
import org.planx.xmlstore.routing.operation.ConnectReceiver;
import org.planx.xmlstore.routing.operation.DataLookupMessage;
import org.planx.xmlstore.routing.operation.DataLookupReceiver;
import org.planx.xmlstore.routing.operation.DataMessage;
import org.planx.xmlstore.routing.operation.HashMessage;
import org.planx.xmlstore.routing.operation.HashReceiver;
import org.planx.xmlstore.routing.operation.HashRequestMessage;
import org.planx.xmlstore.routing.operation.HashRequestReceiver;
import org.planx.xmlstore.routing.operation.NodeLookupMessage;
import org.planx.xmlstore.routing.operation.NodeLookupReceiver;
import org.planx.xmlstore.routing.operation.NodeReplyMessage;
import org.planx.xmlstore.routing.operation.RemoveMessage;
import org.planx.xmlstore.routing.operation.RemoveReceiver;
import org.planx.xmlstore.routing.operation.StoreMessage;
import org.planx.xmlstore.routing.operation.StoreReceiver;
import org.planx.xmlstore.routing.operation.StoreRequestMessage;
import org.planx.xmlstore.routing.operation.StoreRequestReceiver;

public class MessageFactoryImpl
implements MessageFactory {
    public static final byte CODE_CONNECT = 1;
    public static final byte CODE_ACKNOWLEDGE = 2;
    public static final byte CODE_NODE_LOOKUP = 3;
    public static final byte CODE_NODE_REPLY = 4;
    public static final byte CODE_DATA_LOOKUP = 5;
    public static final byte CODE_DATA = 6;
    public static final byte CODE_STORE = 7;
    public static final byte CODE_STORE_REQUEST = 8;
    public static final byte CODE_HASH = 9;
    public static final byte CODE_HASH_REQUEST = 10;
    public static final byte CODE_REMOVE = 11;
    private Map localMap;
    private Node local;
    private Space space;

    public MessageFactoryImpl(Map localMap, Node local, Space space) {
        this.localMap = localMap;
        this.local = local;
        this.space = space;
    }

    @Override
    public Message createMessage(byte code, DataInput in) throws IOException, UnknownMessageException {
        switch (code) {
            case 1: {
                return new ConnectMessage(in);
            }
            case 2: {
                return new AcknowledgeMessage(in);
            }
            case 3: {
                return new NodeLookupMessage(in);
            }
            case 4: {
                return new NodeReplyMessage(in);
            }
            case 5: {
                return new DataLookupMessage(in);
            }
            case 6: {
                return new DataMessage(in);
            }
            case 7: {
                return new StoreMessage(in);
            }
            case 8: {
                return new StoreRequestMessage(in);
            }
            case 9: {
                return new HashMessage(in);
            }
            case 10: {
                return new HashRequestMessage(in);
            }
            case 11: {
                return new RemoveMessage(in);
            }
        }
        throw new UnknownMessageException("Unknown message code: " + code);
    }

    @Override
    public Receiver createReceiver(byte code, MessageServer server) {
        switch (code) {
            case 1: {
                return new ConnectReceiver(server, this.local, this.space);
            }
            case 3: {
                return new NodeLookupReceiver(server, this.local, this.space);
            }
            case 5: {
                return new DataLookupReceiver(server, this.local, this.space, this.localMap);
            }
            case 7: {
                return new StoreReceiver(server, this.local, this.space, this.localMap);
            }
            case 8: {
                return new StoreRequestReceiver(server, this.local, this.space, this.localMap);
            }
            case 9: {
                return new HashReceiver(server, this.local, this.space, this.localMap);
            }
            case 10: {
                return new HashRequestReceiver(server, this.local, this.space, this.localMap);
            }
            case 11: {
                return new RemoveReceiver(server, this.local, this.space, this.localMap);
            }
        }
        return null;
    }
}

