/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import org.planx.util.IndexSet;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.FileSystem;
import org.planx.xmlstore.io.FileSystemIdentifier;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.MemoryFileSystem;
import org.planx.xmlstore.nodes.AbstractNode;
import org.planx.xmlstore.nodes.LocatorListener;
import org.planx.xmlstore.nodes.NodeConverter;
import org.planx.xmlstore.nodes.NodeProxy;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.regions.Group;
import org.planx.xmlstore.regions.InterRegionEdge;
import org.planx.xmlstore.regions.RegionManager;

public class Region {
    private RegionManager manager;
    private LocatorListener ioListener = new IOListener();
    private LocatorListener outgoingListener = new OutgoingListener();
    private IndexSet<LocalLocator, InterRegionEdge> incoming;
    private HashMap<InterRegionEdge.Origin, InterRegionEdge> outgoing;
    private LocalLocator onDiskBlock = null;
    private LocalLocator memoryBlock;
    private MemoryFileSystem mfs = null;
    private RegionNode regionNode = null;
    private WeakHashMap<LocalLocator, SoftReference<SystemNode>> refMap = null;
    private Group group = new Group();
    private boolean isClosed = false;
    private boolean isModified = false;
    private boolean isDirty = false;
    private int id = 0;
    int originalSize = 0;
    int originalNodes = 0;
    int currentNodes = 0;
    private static int assert_graphSize = 100;
    private int assert_currentNodes = 0;

    Region(RegionManager manager, int id) throws IOException {
        this.manager = manager;
        this.id = id;
        FileSystemIdentifier fsi = manager.getFileSystem().currentIdentifier();
        int size = manager.configuration().REGION_SIZE;
        this.mfs = new MemoryFileSystem(size, fsi);
        this.memoryBlock = this.mfs.allocate(size);
        this.initRefMap();
        this.initInterRegionSets();
        this.onDiskBlock = null;
        this.regionNode = null;
        this.isClosed = false;
        this.isModified = false;
        this.isDirty = true;
    }

    private synchronized void initInterRegionSets() {
        this.incoming = new IndexSet();
        this.outgoing = new HashMap();
    }

    public synchronized boolean isContained(LocalLocator loc) {
        if (this.mfs != null) {
            return this.mfs.isContained(loc);
        }
        return this.memoryBlock.isContained(loc);
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isCached() {
        return this.mfs != null;
    }

    public synchronized boolean isPersisted() {
        return this.isClosed() && !this.isCached();
    }

    synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.originalSize = this.memoryBlock.getLen();
        }
    }

    synchronized boolean isDirty() {
        return this.isDirty;
    }

    synchronized void setDirty(boolean newDirty) {
        if (newDirty && !this.isDirty) {
            this.isDirty = true;
            for (InterRegionEdge in : this.incoming) {
                if (in.origin.originRegion == null) continue;
                in.origin.originRegion.setDirty(true);
            }
        }
        this.isDirty = newDirty;
    }

    public synchronized Group getGroup() {
        return this.group;
    }

    public synchronized void setGroup(Group group) {
        this.group = group;
    }

    public int getLocalId() {
        return this.id;
    }

    public synchronized FileSystemIdentifier getIdentifier() {
        if (this.mfs != null) {
            return this.mfs.currentIdentifier();
        }
        return this.memoryBlock.getFileSystemId();
    }

    public synchronized LocalLocator getBound() {
        return this.memoryBlock;
    }

    public synchronized SystemNode load(LocalLocator loc, Reference secondaryRef) throws IOException, UnknownReferenceException {
        if (!this.isContained(loc)) {
            throw new UnknownReferenceException("LocalLocator " + loc + " does not belong to this Region");
        }
        SystemNode node = this.lookupMapping(loc);
        if (node != null) {
            return node;
        }
        this.cache();
        NodeConverter dnav = this.manager.getConverter();
        return dnav.load(loc, secondaryRef, this.memoryBlock, this.mfs, this.ioListener);
    }

    public synchronized LocalLocator save(SystemNode node) throws IOException {
        if (this.isClosed) {
            throw new IOException("Region is closed for further writes");
        }
        if (this.mfs == null || this.refMap == null) {
            throw new IOException("Region not in memory");
        }
        this.isModified = true;
        NodeConverter dnav = this.manager.getConverter();
        LocalLocator loc = dnav.save(node, null, this.mfs, this.outgoingListener);
        this.memoryBlock = this.mfs.all();
        if (this.isContained(loc)) {
            this.addMapping(loc, node);
        }
        if (this.mfs.size() >= (long)this.manager.configuration().REGION_SIZE) {
            this.close();
        }
        return loc;
    }

    private synchronized void addMapping(LocalLocator l, SystemNode node) {
        node = node.get();
        assert (this.assertNode(node, l, true));
        assert (!(node instanceof NodeProxy)) : "node is NodeProxy";
        if (this.refMap != null) {
            this.refMap.put(l, new SoftReference<SystemNode>(node.get()));
        }
    }

    private synchronized SystemNode lookupMapping(LocalLocator l) {
        SystemNode node;
        if (this.refMap == null) {
            return null;
        }
        SoftReference<SystemNode> wn = this.refMap.get(l);
        SystemNode systemNode = node = wn == null ? null : wn.get();
        if (node == null) {
            return null;
        }
        assert (this.assertNode(node, l, true));
        assert (!(node instanceof NodeProxy)) : "node is NodeProxy";
        return node;
    }

    private synchronized void initRefMap() {
        this.refMap = new WeakHashMap();
    }

    synchronized void clearRefMap() {
        if (this.refMap != null) {
            this.refMap.clear();
        }
    }

    public synchronized void cache() throws IOException, UnknownReferenceException {
        this.manager.informCached(this);
        if (this.mfs != null) {
            return;
        }
        if (this.onDiskBlock == null) {
            throw new IOException("Region not persisted");
        }
        if (!this.isClosed) {
            throw new IOException("Internal error: Region is not closed but persisted");
        }
        assert (this.onDiskBlock.getFileSystemId().equals(this.memoryBlock.getFileSystemId()));
        this.mfs = new MemoryFileSystem(this.onDiskBlock.getLen(), this.onDiskBlock.getFileSystemId());
        this.memoryBlock = this.mfs.allocate(this.onDiskBlock.getLen());
        this.mfs.copy(this.manager.getFileSystem(), this.onDiskBlock, this.memoryBlock);
        this.initRefMap();
    }

    public synchronized void flush() throws IOException, UnknownReferenceException {
        if (this.regionNode != null) {
            this.manager.informCached(this);
            return;
        }
        this.persist();
        this.mfs = null;
        this.refMap = null;
        this.regionNode = null;
    }

    public synchronized void persist() throws IOException, UnknownReferenceException {
        if (this.mfs == null) {
            return;
        }
        if (!this.isClosed && this.onDiskBlock != null) {
            throw new IllegalStateException("Internal error: Region is not closed but persisted");
        }
        if (this.isModified) {
            FileSystem fs = this.manager.getFileSystem();
            if (this.onDiskBlock != null && this.regionNode == null) {
                throw new IOException("Previously persisted Region cannot have been modified without a RegionNode");
            }
            if (this.onDiskBlock != null) {
                fs.free(this.onDiskBlock);
            }
            if (this.regionNode != null) {
                assert (this.assertGraph(false, false, false)) : "invalid graph before save";
                this.scanShared(this.regionNode, this.memoryBlock, new Object());
                FileSystemIdentifier fsi = fs.currentIdentifier();
                this.mfs.clear(fsi);
                this.clearRefMap();
                this.currentNodes = 0;
                this.manager.change(this.memoryBlock.getFileSystemId(), this);
                assert (this.manager.lookup(this.mfs.all()) == this) : "manager did not change id";
                assert (!this.mfs.isContained(this.memoryBlock)) : "fsi should change";
                for (SystemNode incomingRoot : this.regionNode.getChildren()) {
                    LocalLocator loc = incomingRoot.getLocator();
                    if (!this.memoryBlock.isContained(loc)) continue;
                    LocalLocator l = this.manager.getConverter().save(incomingRoot, this.memoryBlock, this.mfs, this.ioListener);
                    this.addMapping(l, incomingRoot);
                }
                this.memoryBlock = this.mfs.all();
                this.regionNode.setLocator(this.memoryBlock);
                assert (this.mfs.isContained(this.memoryBlock)) : "memoryBlock mfs mismatch";
            }
            if (this.memoryBlock.getLen() > 0) {
                this.onDiskBlock = fs.allocate(this.memoryBlock.getLen(), this.memoryBlock.getFileSystemId());
                assert (this.onDiskBlock.getFileSystemId().equals(this.memoryBlock.getFileSystemId()));
                fs.copy(this.mfs, this.memoryBlock, this.onDiskBlock);
            } else {
                this.onDiskBlock = null;
            }
        }
        this.isModified = false;
        this.isClosed = true;
    }

    private synchronized void scanShared(SystemNode node, LocalLocator loc, Object visitToken) {
        if (!this.isContained(loc)) {
            return;
        }
        if (node.getVisitToken() == visitToken) {
            node.setShared(true);
            return;
        }
        node.setVisitToken(visitToken);
        node.setShared(false);
        List<SystemNode> children = node.getChildren();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            SystemNode child = children.get(i);
            LocalLocator target = child.getLocator();
            if (!this.isContained(target)) continue;
            this.scanShared(child, target, visitToken);
        }
    }

    synchronized SystemNode getRegionRoot(Region twin) throws IOException, UnknownReferenceException {
        this.releaseRegionRoot();
        this.cache();
        ArrayList<SystemNode> roots = new ArrayList<SystemNode>(this.incoming.size());
        ArrayList<InterRegionEdge> ins = new ArrayList<InterRegionEdge>(this.incoming.size());
        for (InterRegionEdge in : this.incoming) {
            SystemNode node = this.load(in.targetNode, null);
            assert (node.getLocator() != null) : "root's locator null";
            assert (this.isContained(node.getLocator())) : "region does not contain locator in root";
            roots.add(node);
            ins.add(in);
        }
        this.regionNode = new RegionNode(roots, ins);
        if (twin != null) {
            if (twin.regionNode == null) {
                throw new NullPointerException();
            }
            this.mergeWithTwin(twin);
            twin.mergeWithTwin(this);
        }
        this.isModified = true;
        return this.regionNode;
    }

    private synchronized void mergeWithTwin(Region twin) {
        for (InterRegionEdge out : this.outgoing.values()) {
            assert (Region.assertConnect(out, this, out.targetRegion));
            if (twin != out.targetRegion) continue;
            SystemNode real = twin.lookupMapping(out.targetNode);
            SystemNode parent = this.lookupMapping(out.origin.originNode);
            if (real == null || parent == null) continue;
            parent.setChild(out.origin.childIndex, real);
        }
    }

    synchronized void releaseRegionRoot() {
        if (this.regionNode != null && this.isModified) {
            throw new IllegalStateException("Changes made to previous RegionNode has not been persisted");
        }
        this.regionNode = null;
    }

    synchronized void prepareMend(Region twin) {
        for (InterRegionEdge out : this.outgoing.values()) {
            out.targetRegion.removeIncoming(out);
        }
        for (Region r : this.manager.getRegions()) {
            if (r == this || r == twin) continue;
            r.clearRefMap();
        }
        this.initInterRegionSets();
    }

    synchronized boolean mend(Region twin) throws UnknownReferenceException {
        InterRegionEdge oldIn = null;
        InterRegionEdge newIn = null;
        SystemNode newRoot = null;
        LocalLocator newLoc = null;
        LocalLocator oldLoc = null;
        LocalLocator oldOrigin = null;
        boolean isConsistent = true;
        boolean isGlobalRoot = false;
        boolean hadForeignOrigin = false;
        Region oldOriginRegion = null;
        Region targetRegion = null;
        if (twin == this) {
            throw new IllegalArgumentException("Regions identical");
        }
        if (this.regionNode == null) {
            throw new NullPointerException("Region node null");
        }
        if (twin != null && twin.regionNode == null) {
            throw new NullPointerException("Region node null in twin");
        }
        if (this.isModified) {
            throw new IllegalStateException("This region not persisted");
        }
        if (twin != null && twin.isModified) {
            throw new IllegalStateException("Twin region not persisted");
        }
        try {
            assert (this.manager.lookup(this.memoryBlock) == this) : "manager lookup of memoryBlock does not yield this region";
            List<SystemNode> roots = this.regionNode.roots;
            List<InterRegionEdge> oldIns = this.regionNode.ins;
            Object visitToken = new Object();
            int max = roots.size();
            for (int i = 0; i < max; ++i) {
                oldIn = oldIns.get(i);
                newRoot = roots.get(i);
                newLoc = newRoot.getLocator();
                oldLoc = oldIn.targetNode;
                oldOrigin = oldIn.origin.originNode;
                oldOriginRegion = oldIn.origin.originRegion;
                isGlobalRoot = oldOriginRegion == null;
                boolean bl = hadForeignOrigin = oldOriginRegion != this && (twin == null || oldOriginRegion != twin);
                assert (newRoot != null) : "newRoot is null";
                assert (newLoc != null) : "newLoc is null";
                assert (!newLoc.equals(oldLoc)) : "new and old locators are equal";
                assert (Region.assertEdge(oldIn, oldOriginRegion, this)) : "edge failed";
                assert (oldOriginRegion != this) : "origin region must not be itself";
                assert (oldOriginRegion == this || twin != null && oldOriginRegion == twin || this.manager.lookup(oldOrigin) == oldOriginRegion) : "foreign origin locator's region has changed;oldOrigin=" + oldOrigin + ";oldOriginRegion=" + oldOriginRegion + ";manager.lookup=" + this.manager.lookup(oldOrigin);
                if (this.isContained(newLoc)) {
                    assert (this.isContained(newLoc)) : "new locator is not in this region";
                    assert (this.manager.lookup(newLoc) == this) : "manager lookup of new locator does not yield this region";
                    if (isGlobalRoot || hadForeignOrigin) {
                        newIn = new InterRegionEdge(newLoc, oldOrigin, oldIn.origin.childIndex, this, oldOriginRegion);
                        this.addIncoming(newIn);
                        if (isGlobalRoot) {
                            isConsistent = this.manager.rootMoved(oldLoc, newLoc) & isConsistent;
                        } else {
                            oldOriginRegion.changeOutgoing(newIn);
                        }
                    }
                } else {
                    Region region = targetRegion = twin == null ? this.manager.lookup(newLoc) : twin;
                    assert (targetRegion != null) : "target/twin region is null";
                    assert (targetRegion.isContained(newLoc)) : "new locator is not in target/twin region;targetRegion.memoryBlock=" + targetRegion.memoryBlock;
                    assert (this.manager.lookup(newLoc) == targetRegion) : "manager lookup of new locator does not yield target/twin region;targetRegion.memoryBlock=" + targetRegion.memoryBlock;
                    if (isGlobalRoot || hadForeignOrigin) {
                        newIn = new InterRegionEdge(newLoc, oldOrigin, oldIn.origin.childIndex, targetRegion, oldOriginRegion);
                        targetRegion.addIncoming(newIn);
                        if (isGlobalRoot) {
                            isConsistent = this.manager.rootMoved(oldLoc, newLoc) & isConsistent;
                        } else {
                            oldOriginRegion.changeOutgoing(newIn);
                        }
                    }
                }
                this.scanOutgoing(newRoot, newLoc, visitToken);
            }
            assert (this.assertGraph(true, true, true)) : "invalid graph after save";
        }
        catch (AssertionError e) {
            String graph = this.assert_currentNodes < assert_graphSize ? ";" + this.assertGraphOutput() : "";
            this.rethrow(e, ";twin=" + twin + ";oldIn=" + oldIn + ";newIn=" + newIn + ";newRoot=" + Region.toString(newRoot) + ";newLoc=" + newLoc + ";isGlobalRoot=" + isGlobalRoot + ";hadForeignOrigin=" + hadForeignOrigin + graph + ";targetRegion=" + targetRegion);
        }
        if (this.memoryBlock.getLen() == 0) {
            this.manager.remove(this);
        }
        return isConsistent;
    }

    private synchronized void scanOutgoing(SystemNode node, LocalLocator loc, Object visitToken) {
        if (!this.isContained(loc)) {
            return;
        }
        if (node.getVisitToken() == visitToken) {
            return;
        }
        node.setVisitToken(visitToken);
        assert (this.assertNode(node, false));
        List<SystemNode> children = node.getChildren();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            SystemNode child = children.get(i);
            LocalLocator target = child.getLocator();
            assert (target != null) : "child node has null locator. Probable cause: node with deprecated locator in refMap?;node=" + Region.toString(node);
            if (this.isContained(target)) {
                this.scanOutgoing(child, target, visitToken);
                continue;
            }
            Region r = this.manager.lookup(target);
            assert (r != null) : "cannot find target region for child locator.Probable cause: node with deprecated locator in refMap?;target=" + target + ";node=" + Region.toString(node);
            InterRegionEdge edge = new InterRegionEdge(target, loc, i, r, this);
            this.addOutgoing(edge);
            r.addIncoming(edge);
            assert (Region.assertConnect(edge, this, r));
        }
    }

    synchronized void addIncoming(InterRegionEdge in) {
        assert (Region.assertNewEdge(in, in.origin.originRegion, this));
        this.incoming.add(in.targetNode, in);
    }

    synchronized void removeIncoming(InterRegionEdge in) {
        assert (Region.assertEdge(in, in.origin.originRegion, this));
        this.incoming.remove(in.targetNode, in);
    }

    private synchronized void addOutgoing(InterRegionEdge out) {
        assert (Region.assertNewEdge(out, this, out.targetRegion));
        this.outgoing.put(out.origin, out);
    }

    private synchronized void removeOutgoing(InterRegionEdge out) {
        assert (Region.assertEdge(out, this, out.targetRegion));
        this.outgoing.remove(out.origin);
        if (this.refMap != null) {
            this.refMap.remove(out.origin.originNode);
        }
    }

    private synchronized InterRegionEdge lookupOutgoing(LocalLocator origin, int childIndex) {
        InterRegionEdge out = this.outgoing.get(new InterRegionEdge.Origin(origin, childIndex, this));
        if (out == null) {
            return null;
        }
        try {
            assert (Region.assertEdge(out, this, out.targetRegion));
            assert (out.origin.originNode == null && origin == null || out.origin.originNode != null && origin != null && out.origin.originNode.equals(origin)) : "looked-up edge does not match argument locator";
            assert (out.origin.childIndex == childIndex) : "looked-up edge does not match argument childIndex";
        }
        catch (AssertionError e) {
            this.rethrow(e, ";origin=" + origin + ";childIndex=" + childIndex + ";edge=" + out);
        }
        return out;
    }

    private synchronized InterRegionEdge lookupOutgoing(InterRegionEdge.Origin origin) {
        InterRegionEdge out = this.outgoing.get(origin);
        if (out == null) {
            return null;
        }
        try {
            assert (Region.assertEdge(out, this, out.targetRegion));
            assert (out.origin.originNode == null && origin.originNode == null || out.origin.originNode != null && origin.originNode != null && out.origin.originNode.equals(origin.originNode)) : "looked-up edge does not match argument's origin locator";
            assert (out.origin.childIndex == origin.childIndex) : "looked-up edge does not match argument's childIndex";
        }
        catch (AssertionError e) {
            this.rethrow(e, ";origin=" + origin + ";edge=" + out);
        }
        return out;
    }

    private synchronized boolean incomingContains(LocalLocator target) {
        return this.incoming.contains(target);
    }

    private synchronized void changeOutgoing(InterRegionEdge newOut) {
        InterRegionEdge oldOut = this.lookupOutgoing(newOut.origin);
        assert (oldOut != null) : "old outgoing edge is null;newOut=" + newOut + ";" + oldOut;
        this.removeOutgoing(oldOut);
        this.addOutgoing(newOut);
    }

    public synchronized String toString() {
        return "R" + this.id + "{" + this.memoryBlock.getFileSystemId() + "/" + (this.mfs == null ? "null" : this.mfs.all().getFileSystemId()) + "}";
    }

    public synchronized int size() {
        return this.memoryBlock.getLen();
    }

    public synchronized int originalSize() {
        return this.originalSize;
    }

    public synchronized int incomingSize() {
        return this.incoming.size();
    }

    public synchronized int outgoingSize() {
        return this.outgoing.size();
    }

    public synchronized Statistics statistics() {
        return new Statistics(this);
    }

    static boolean assertNewEdge(InterRegionEdge edge, Region origin, Region target) {
        try {
            Region.assertEdge(edge, origin, target);
            assert (target.isContained(edge.targetNode)) : "target node not in target region";
            assert (!target.isContained(edge.origin.originNode)) : "origin node in target region";
            assert (origin == null || origin.isContained(edge.origin.originNode)) : "origin node not in origin region";
            assert (origin == null || !origin.isContained(edge.targetNode)) : "target node in origin region";
            assert (origin == null || origin.manager.lookup(edge.origin.originNode) == edge.origin.originRegion) : "manager lookup of origin does not yield origin region";
            assert (target.manager.lookup(edge.targetNode) == edge.targetRegion) : "manager lookup of target node does not yield target region";
        }
        catch (AssertionError e) {
            Region.rethrows(e, ";edge=" + edge + ";origin=" + origin + ";target=" + target);
        }
        return true;
    }

    static boolean assertEdge(InterRegionEdge edge, Region origin, Region target) {
        try {
            assert (edge != null) : "edge null";
            assert (origin != target) : "origin and target regions are the same";
            assert (edge.targetRegion != null) : "target region is null";
            assert (edge.targetNode != null) : "target node is null";
            assert (edge.targetRegion == target) : "target region mismatch";
            assert (edge.origin.originRegion == origin) : "origin region mismatch";
            assert (edge.origin.childIndex >= 0) : "child index negative";
            assert (edge.origin.originNode == null && edge.origin.originRegion == null || edge.origin.originNode != null && edge.origin.originRegion != null) : "origin node and origin region null mismatch";
            assert (edge.targetRegion != edge.origin.originRegion) : "origin and target regions are the same";
            assert (edge.targetNode != edge.origin.originNode) : "origin node and target node are the same";
        }
        catch (AssertionError e) {
            Region.rethrows(e, ";edge=" + edge + ";origin=" + origin + ";target=" + target);
        }
        return true;
    }

    static boolean assertConnect(InterRegionEdge edge, Region origin, Region target) {
        try {
            Region.assertNewEdge(edge, origin, target);
            assert (origin == null || edge.equals(origin.lookupOutgoing(edge.origin))) : "origin region lookup does not yield edge";
            assert (target.incomingContains(edge.targetNode)) : "target region does not contain edge (1)";
            assert (target.incoming.get(edge.targetNode).contains(edge)) : "target region does not contain edge (2)";
        }
        catch (AssertionError e) {
            Region.rethrows(e, ";edge=" + edge + ";origin=" + origin + ";target=" + target);
        }
        return true;
    }

    boolean assertIncomingConnect() {
        try {
            for (InterRegionEdge edge : this.incoming) {
                assert (Region.assertConnect(edge, edge.origin.originRegion, this)) : "incoming set failed connection assertion";
            }
        }
        catch (AssertionError e) {
            this.rethrow(e, ";incoming.size=" + this.incoming.size() + ";outgoing.size=" + this.outgoing.size() + ";refMap.size=" + (this.refMap == null ? "null" : Integer.valueOf(this.refMap.size())));
        }
        return true;
    }

    boolean assertOutgoingConnect() {
        try {
            for (InterRegionEdge edge : this.outgoing.values()) {
                assert (Region.assertConnect(edge, this, edge.targetRegion)) : "outgoing set failed connection assertion";
            }
        }
        catch (AssertionError e) {
            this.rethrow(e, ";incoming.size=" + this.incoming.size() + ";outgoing.size=" + this.outgoing.size() + ";refMap.size=" + (this.refMap == null ? "null" : Integer.valueOf(this.refMap.size())));
        }
        return true;
    }

    synchronized boolean assertNode(SystemNode node, boolean verifyManager) {
        try {
            assert (node != null) : "node is null";
            assert (node.getLocator() != null) : "reference in node is null";
            assert (this.mfs != null) : "memory file system should not be null at this point";
            assert (this.mfs.isContained(node.getLocator())) : "this region does not contain the node's locator";
            if (verifyManager) assert (this.manager.lookup(node.getLocator()) == this) : "manager lookup of node's locator does not yield this region";
        }
        catch (AssertionError e) {
            this.rethrow(e, ";nodeLoc=" + Region.toLocator(node) + ";node=" + Region.toString(node) + ";manager.lookup=" + this.manager.lookup(Region.toLocator(node)) + ";refMap.size=" + (this.refMap == null ? "null" : Integer.valueOf(this.refMap.size())) + ";incomingContains=" + this.incomingContains(Region.toLocator(node)));
        }
        return true;
    }

    synchronized boolean assertNode(SystemNode node, LocalLocator loc, boolean verifyManager) {
        try {
            assert (loc != null) : "argument locator is null";
            assert (loc.equals(Region.toLocator(node))) : "argument locator does not match node's locator";
            this.assertNode(node, verifyManager);
        }
        catch (AssertionError e) {
            this.rethrow(e, ";loc=" + loc + ";nodeLoc=" + Region.toLocator(node) + ";node=" + Region.toString(node) + ";manager.lookup=" + this.manager.lookup(Region.toLocator(node)) + ";refMap.size=" + (this.refMap == null ? "null" : Integer.valueOf(this.refMap.size())) + ";incomingContains=" + this.incomingContains(Region.toLocator(node)));
        }
        return true;
    }

    synchronized boolean assertGraph(boolean verifyShared, boolean verifyOutgoing, boolean verifyNodes) {
        int out = 0;
        this.assert_currentNodes = 0;
        try {
            assert (this.regionNode != null) : "must have region node at this point";
            Object token = new Object();
            for (SystemNode node : this.regionNode.getChildren()) {
                if (!this.isContained(Region.toLocator(node))) continue;
                out += this.assertGraph(node, verifyShared, token);
            }
            if (verifyNodes) assert (this.assert_currentNodes == this.currentNodes) : "mismatch in number of nodes";
            if (verifyOutgoing) assert (out == this.outgoing.size()) : "mismatch in outgoing set's size";
        }
        catch (AssertionError e) {
            String graph = this.assert_currentNodes < assert_graphSize ? ";" + this.assertGraphOutput() : "";
            this.rethrow(e, ";assertOut=" + out + ";out=" + this.outgoing.size() + ";assertNodes=" + this.assert_currentNodes + ";currentNodes=" + this.currentNodes + ";verifyShared=" + verifyShared + ";verifyOutgoing=" + verifyOutgoing + graph);
        }
        return true;
    }

    private synchronized int assertGraph(SystemNode node, boolean verifyShared, Object visitToken) {
        int out = 0;
        if (!this.isContained(Region.toLocator(node))) {
            return 1;
        }
        this.assertNode(node, true);
        if (node.getVisitToken() == visitToken) {
            if (verifyShared) assert (node.isShared()) : "node is shared but does not know it;node=" + Region.toString(node) + ";nodeLoc=" + Region.toLocator(node);
            return 0;
        }
        node.setVisitToken(visitToken);
        LocalLocator loc = Region.toLocator(node);
        List<SystemNode> children = node.getChildren();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            SystemNode child = children.get(i);
            LocalLocator l = Region.toLocator(child);
            assert (child != null) : "child is null";
            assert (child != node) : "cyclic node reference";
            assert (l != loc) : "cyclic locator reference";
            out += this.assertGraph(child, verifyShared, visitToken);
        }
        ++this.assert_currentNodes;
        return out;
    }

    private synchronized String assertGraphOutput() {
        if (this.regionNode == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.assertGraphOutput(this.regionNode, sb, 0, new Object());
        return sb.toString();
    }

    private synchronized void assertGraphOutput(SystemNode node, StringBuilder sb, int indent, Object visitToken) {
        Region.indent(sb, indent);
        if (node == null) {
            sb.append("<NULL/>;");
            return;
        }
        if (!this.isContained(Region.toLocator(node))) {
            sb.append("<OUTSIDE LOC=" + Region.toLocator(node) + ">");
            sb.append(node.getNodeValue());
            sb.append("</OUTSIZE>;");
            return;
        }
        String s = node.getVisitToken() == visitToken ? " SHARED=TRUE" : "";
        node.setVisitToken(visitToken);
        if (node.getType() == 0) {
            sb.append("<" + node.getNodeValue() + " LOC=" + Region.toLocator(node) + s + ">;");
            for (SystemNode child : node.getChildren()) {
                this.assertGraphOutput(child, sb, indent + 1, visitToken);
            }
            Region.indent(sb, indent);
            sb.append("</" + node.getNodeValue() + ">;");
        } else {
            sb.append("<CHARDATA LOC=" + Region.toLocator(node) + s + ">");
            sb.append(node.getNodeValue());
            sb.append("</CHARDATA>;");
        }
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent * 2; ++i) {
            sb.append(' ');
        }
    }

    synchronized boolean assertInterRegion() {
        this.assertIncomingConnect();
        this.assertOutgoingConnect();
        assert (this.assertGraph(true, true, true)) : "invalid graph";
        return true;
    }

    static void rethrows(AssertionError e, String detail) {
        detail = Region.format(((Throwable)((Object)e)).getMessage() + detail);
        AssertionError a = new AssertionError((Object)detail);
        ((Throwable)((Object)a)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
        throw a;
    }

    void rethrow(AssertionError e, String detail) {
        detail = Region.format(((Throwable)((Object)e)).getMessage() + ";region=" + this + detail);
        AssertionError a = new AssertionError((Object)detail);
        ((Throwable)((Object)a)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
        throw a;
    }

    static String toString(SystemNode node) {
        if (node == null) {
            return "null";
        }
        String cls = node.getClass().getName();
        cls = cls.substring(cls.lastIndexOf(46) + 1);
        return cls + ":" + node.getNodeValue();
    }

    static LocalLocator toLocator(SystemNode node) {
        if (node == null) {
            return null;
        }
        return node.getLocator();
    }

    static String format(String detail) {
        return detail.replaceAll(";", "\n");
    }

    public static class Statistics {
        public LocalLocator onDiskBlock;
        public LocalLocator memoryBlock;
        public boolean isClosed;
        public boolean isModified;
        public boolean isDirty;
        public boolean isInMemory;
        public boolean hasRegionRoot;
        public int size;
        public int originalSize;
        public int refMapSize;
        public int incomingSize;
        public int outgoingSize;
        public int originalNodes;
        public int currentNodes;
        public String region;
        public String refMap;
        public String incoming;
        public String outgoing;

        Statistics(Region r) {
            this.region = r.toString();
            this.onDiskBlock = r.onDiskBlock;
            this.memoryBlock = r.memoryBlock;
            this.isClosed = r.isClosed;
            this.isModified = r.isModified;
            this.isDirty = r.isDirty;
            this.isInMemory = r.mfs != null;
            this.hasRegionRoot = r.regionNode != null;
            this.size = r.memoryBlock.getLen();
            this.originalSize = r.originalSize;
            this.originalNodes = r.originalNodes;
            this.currentNodes = r.currentNodes;
            this.refMapSize = r.refMap == null ? 0 : r.refMap.size();
            this.incomingSize = r.incoming.size();
            this.outgoingSize = r.outgoing.size();
        }

        static String toString(Collection<?> c) {
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            for (Object o : c) {
                sb.append("      ");
                sb.append(o.toString());
                sb.append("\n");
            }
            sb.append("    }");
            return sb.toString();
        }

        public String toString() {
            return this.full();
        }

        public String brief() {
            return this.region + "{size=" + this.size + ",originalSize=" + this.originalSize + ",currentNodes=" + this.currentNodes + ",originalNodes=" + this.originalNodes + ",incoming=" + this.incomingSize + ",outgoing=" + this.outgoingSize + "}";
        }

        public String full() {
            StringBuilder sb = new StringBuilder();
            sb.append("  Region " + this.region + "\n");
            sb.append("    onDiskBlock:   " + this.onDiskBlock + "\n");
            sb.append("    memoryBlock:   " + this.memoryBlock + "\n");
            sb.append("    size:          " + this.size + "\n");
            sb.append("    originalSize:  " + this.originalSize + "\n");
            sb.append("    currentNodes:  " + this.currentNodes + "\n");
            sb.append("    originalNodes: " + this.originalNodes + "\n");
            sb.append("    isClosed:      " + this.isClosed + "\n");
            sb.append("    isModified:    " + this.isModified + "\n");
            sb.append("    isDirty:       " + this.isDirty + "\n");
            sb.append("    isInMemory:    " + this.isInMemory + "\n");
            sb.append("    hasRegionRoot: " + this.hasRegionRoot + "\n");
            sb.append("    refMapSize:    " + this.refMapSize + "\n");
            sb.append("    incomingSize:  " + this.incomingSize + "\n");
            sb.append("    outgoingSize:  " + this.outgoingSize + "\n");
            sb.append("    refMap:        " + this.refMap + "\n");
            sb.append("    incoming:      " + this.incoming + "\n");
            sb.append("    outgoing:      " + this.outgoing + "\n");
            return sb.toString();
        }
    }

    private class RegionNode
    extends AbstractNode {
        List<SystemNode> roots;
        List<InterRegionEdge> ins;
        int height = -1;
        LocalLocator loc = null;

        RegionNode(List<SystemNode> roots, List<InterRegionEdge> ins) {
            this.roots = roots;
            this.ins = ins;
            this.loc = Region.this.memoryBlock;
        }

        @Override
        public void setChild(int index, SystemNode child) {
            this.roots.set(index, child);
        }

        @Override
        public boolean isShared() {
            return false;
        }

        @Override
        public void setShared(boolean isShared) {
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public byte getType() {
            return 0;
        }

        @Override
        public String getNodeValue() {
            return "RegionNode";
        }

        @Override
        public List<SystemNode> getChildren() {
            return this.roots;
        }

        public void addChild(SystemNode child) {
            this.roots.add(child);
        }

        @Override
        public List<Attribute> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public String getAttribute(String attrName) {
            return null;
        }

        @Override
        public String[] getAttributeNames() {
            return new String[0];
        }

        @Override
        public LocalLocator getLocator() {
            return this.loc;
        }

        @Override
        public void setLocator(LocalLocator loc) {
            this.loc = loc;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            List<SystemNode> children = this.getChildren();
            List<Attribute> attributes = this.getAttributes();
            result.append("<" + this.getNodeValue());
            for (Attribute attr : attributes) {
                result.append(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
            }
            if (children.size() > 0) {
                result.append(">\n");
                for (SystemNode node : children) {
                    result.append(node.toString() + "\n");
                }
                result.append("</" + this.getNodeValue() + ">");
            } else {
                result.append("/>");
            }
            return result.toString();
        }
    }

    private class OutgoingListener
    extends IOListener
    implements LocatorListener {
        private OutgoingListener() {
        }

        @Override
        public void nodeSaved(LocalLocator l, SystemNode node, boolean hasOutgoing) {
            super.nodeSaved(l, node, hasOutgoing);
            if (hasOutgoing) {
                List<SystemNode> children = node.getChildren();
                int max = children.size();
                for (int i = 0; i < max; ++i) {
                    LocalLocator target = children.get(i).getLocator();
                    if (Region.this.isContained(target)) continue;
                    Region r = Region.this.manager.lookup(target);
                    InterRegionEdge edge = new InterRegionEdge(target, l, i, r, Region.this);
                    Region.this.addOutgoing(edge);
                    r.addIncoming(edge);
                    assert (Region.assertConnect(edge, Region.this, r));
                }
            }
        }
    }

    private class IOListener
    implements LocatorListener {
        private IOListener() {
        }

        @Override
        public LocalLocator locatorLoaded(LocalLocator l, LocalLocator parent, int childIndex) {
            InterRegionEdge out = Region.this.lookupOutgoing(parent, childIndex);
            if (out != null) {
                assert (Region.assertConnect(out, Region.this, out.targetRegion));
                return out.targetNode;
            }
            l.setFileSystemId(Region.this.getIdentifier());
            return l;
        }

        @Override
        public void nodeLoaded(LocalLocator l, SystemNode node, boolean hasOutgoing) {
            assert (Region.this.assertNode(node, l, true));
            if (hasOutgoing || node.isShared() || Region.this.incomingContains(l)) {
                Region.this.addMapping(l, node);
            }
        }

        @Override
        public SystemNode lookup(LocalLocator l) {
            return Region.this.lookupMapping(l);
        }

        @Override
        public void nodeSaved(LocalLocator l, SystemNode node, boolean hasOutgoing) {
            assert (Region.this.assertNode(node, l, true));
            if (!Region.this.isClosed) {
                ++Region.this.originalNodes;
            } else {
                ++Region.this.currentNodes;
            }
            if (hasOutgoing || node.isShared()) {
                Region.this.addMapping(l, node);
            }
        }
    }
}

