/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.references;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.util.DiscriminatorAdapter;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.util.Concurrency;

public class ReferenceProxy
implements Reference {
    public static final byte CLASS_ID = 4;
    private Future<Reference> future;

    public ReferenceProxy(Future<Reference> future) {
        this.future = future;
    }

    public Reference get() {
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Reference resolve(Reference vref) {
        if (vref instanceof ReferenceProxy) {
            return ReferenceProxy.resolve(((ReferenceProxy)vref).get());
        }
        return vref;
    }

    public static Streamer<ReferenceProxy> getStreamer() {
        final PolymorphicStreamer<Reference> vrefStreamer = Streamers.getPolymorphicStreamer(Reference.class);
        return new Streamer<ReferenceProxy>(){

            @Override
            public void toStream(DataOutput out, ReferenceProxy vref) throws IOException {
                vrefStreamer.toStream(out, ReferenceProxy.resolve(vref));
            }

            @Override
            public ReferenceProxy fromStream(DataInput in) throws IOException {
                Reference vref = (Reference)vrefStreamer.fromStream(in);
                Future<Reference> future = Concurrency.future(vref);
                return new ReferenceProxy(future);
            }
        };
    }

    public static Discriminator<ReferenceProxy> getDiscriminator() {
        return new DiscriminatorAdapter<ReferenceProxy, Reference>(DiscriminatorFactory.instance().getPolymorphicDiscriminator(Reference.class)){

            @Override
            protected Reference transform(ReferenceProxy vref) {
                return ReferenceProxy.resolve(vref);
            }
        };
    }
}

