/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.List;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.nodes.AbstractNode;
import org.planx.xmlstore.nodes.SystemNode;

public abstract class NodeProxy
extends AbstractNode {
    private SoftReference<SystemNode> nodeRef;
    private SoftReference<LocalLocator> loc;

    protected NodeProxy(Reference ref) {
        if (ref == null) {
            throw new NullPointerException("Reference is null");
        }
        if (ref instanceof LocalLocator) {
            this.setLoc((LocalLocator)ref);
        }
        this.ref = ref;
    }

    protected NodeProxy(LocalLocator l, Reference ref) {
        if (l == null && ref == null) {
            throw new NullPointerException();
        }
        this.ref = ref;
        this.setLoc(l);
    }

    protected void setLoc(LocalLocator l) {
        this.loc = new SoftReference<LocalLocator>(l);
    }

    protected LocalLocator getLoc() {
        return this.loc == null ? null : this.loc.get();
    }

    private SystemNode doGenerate() {
        SystemNode node;
        SystemNode systemNode = node = this.nodeRef == null ? null : this.nodeRef.get();
        if (node == null) {
            try {
                node = this.generate();
            }
            catch (UnknownReferenceException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.nodeRef = new SoftReference<SystemNode>(node);
        }
        if (node == this) {
            throw new IllegalStateException("NodeProxy generated itself, loc=" + this.getLoc() + ", ref=" + this.ref);
        }
        return node;
    }

    protected abstract SystemNode generate() throws UnknownReferenceException, IOException;

    @Override
    public SystemNode get() {
        SystemNode node = this.doGenerate().get();
        if (node.getLocator() != null) {
            this.setLoc(node.getLocator());
        } else {
            node.setLocator(this.getLoc());
        }
        return node;
    }

    @Override
    public boolean isMutable() {
        return this.doGenerate().isMutable();
    }

    @Override
    public byte getType() {
        return this.doGenerate().getType();
    }

    @Override
    public String getNodeValue() {
        return this.doGenerate().getNodeValue();
    }

    @Override
    public List<SystemNode> getChildren() {
        return this.doGenerate().getChildren();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.doGenerate().getAttributes();
    }

    @Override
    public String getAttribute(String attrName) {
        return this.doGenerate().getAttribute(attrName);
    }

    @Override
    public String[] getAttributeNames() {
        return this.doGenerate().getAttributeNames();
    }

    @Override
    public boolean isShared() {
        return this.doGenerate().isShared();
    }

    @Override
    public void setShared(boolean isShared) {
        this.doGenerate().setShared(isShared);
    }

    @Override
    public int getHeight() {
        return this.doGenerate().getHeight();
    }

    @Override
    public void setHeight(int height) {
        this.doGenerate().setHeight(height);
    }

    @Override
    public LocalLocator getLocator() {
        LocalLocator l = this.getLoc();
        if (l == null && this.ref instanceof LocalLocator) {
            l = (LocalLocator)this.ref;
            this.setLoc(l);
        }
        return l;
    }

    @Override
    public void setLocator(LocalLocator l) {
        this.setLoc(l);
        this.doGenerate().setLocator(l);
    }

    @Override
    public void setChild(int index, SystemNode child) {
        this.doGenerate().setChild(index, child);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeProxy) {
            NodeProxy p = (NodeProxy)o;
            Reference ref1 = this.getLoc();
            Reference ref2 = p.getLoc();
            if (ref1 != null && ref2 != null && ref1.equals(ref2)) {
                return true;
            }
            ref1 = this.getReference();
            ref2 = p.getReference();
            if (ref1 != null && ref2 != null && ref1.equals(ref2)) {
                return true;
            }
        }
        if (!(o instanceof Node)) {
            return false;
        }
        return this.doGenerate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.doGenerate().hashCode();
    }

    public String toString() {
        return this.doGenerate().toString();
    }

    public void unload() {
        this.nodeRef = null;
        this.loc = null;
    }
}

