/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.character.CharSequenceDiscriminator;
import org.planx.msd.lang.EquivalenceClassDiscriminator;
import org.planx.msd.list.ShortSetDiscriminator;
import org.planx.msd.list.SizeRandomAccessListDiscriminator;
import org.planx.msd.number.ByteDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.nodes.DVMAttribute;
import org.planx.xmlstore.nodes.SystemNode;

public class NodeDiscriminator
extends AbstractDiscriminator<SystemNode> {
    private Discriminator<Byte> typeDisc;
    private Discriminator<CharSequence> valueDisc;
    private Discriminator<List<SystemNode>> childListDisc;
    private Discriminator<List<Attribute>> attrsListDisc;

    public NodeDiscriminator() {
        this(DiscriminatorFactory.instance().getMemory());
    }

    public NodeDiscriminator(Memory memory) {
        this.typeDisc = new ByteDiscriminator(memory);
        this.valueDisc = new CharSequenceDiscriminator<CharSequence>(memory);
        EquivalenceClassDiscriminator childDisc = new EquivalenceClassDiscriminator();
        this.childListDisc = new SizeRandomAccessListDiscriminator<SystemNode>(childDisc, memory);
        Discriminator<Attribute> attrDisc = DVMAttribute.getDiscriminator(memory);
        this.attrsListDisc = new ShortSetDiscriminator<Attribute>(attrDisc, memory);
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends SystemNode, S> e) {
        int vsize = values.size();
        if (vsize == 0) {
            return Collections.emptyList();
        }
        if (vsize == 1) {
            List<S> l1 = Collections.singletonList(e.getValue(values.get(0)));
            return Collections.singletonList(l1);
        }
        Extractor eValue = new Extractor<U, CharSequence, U>(){

            @Override
            public CharSequence getLabel(U elm) {
                return ((SystemNode)e.getLabel(elm)).getNodeValue();
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
        Extractor eType = new Extractor<U, Byte, U>(){

            @Override
            public Byte getLabel(U elm) {
                return ((SystemNode)e.getLabel(elm)).getType();
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
        Extractor eChildren = new Extractor<U, List<SystemNode>, U>(){

            @Override
            public List<SystemNode> getLabel(U elm) {
                return ((SystemNode)e.getLabel(elm)).getChildren();
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
        Extractor eAttrs = new Extractor<U, List<Attribute>, S>(){

            @Override
            public List<Attribute> getLabel(U elm) {
                return ((SystemNode)e.getLabel(elm)).getAttributes();
            }

            @Override
            public S getValue(U elm) {
                return e.getValue(elm);
            }
        };
        return Discriminators.discriminate(values, this.valueDisc, eValue, this.childListDisc, eChildren, this.typeDisc, eType, this.attrsListDisc, eAttrs);
    }
}

