/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.io.UnsupportedEncodingException;

public class Converter {
    public static int bytes2int(byte[] ab, int i) {
        return (ab[i] & 0xFF) << 24 | (ab[i + 1] & 0xFF) << 16 | (ab[i + 2] & 0xFF) << 8 | ab[i + 3] & 0xFF;
    }

    public static byte[] int2bytes(int i) {
        byte[] ab = new byte[]{(byte)(0xFF & i >> 24), (byte)(0xFF & i >> 16), (byte)(0xFF & i >> 8), (byte)(0xFF & i)};
        return ab;
    }

    public static void int2bytebuf(int i, int off, byte[] ab) {
        if (ab.length < off + 4) {
            throw new ArrayIndexOutOfBoundsException("ab.length: " + ab.length + " off: " + off + " ab: " + new String(ab));
        }
        ab[off] = (byte)(0xFF & i >> 24);
        ab[off + 1] = (byte)(0xFF & i >> 16);
        ab[off + 2] = (byte)(0xFF & i >> 8);
        ab[off + 3] = (byte)(0xFF & i);
    }

    public static String toHex(byte b) {
        String h = Integer.toHexString(b & 0xFF);
        if (h.length() == 1) {
            return "0" + h;
        }
        return h;
    }

    public static String toHex(byte[] bs) {
        StringBuilder sb = new StringBuilder(2 * bs.length);
        for (int i = 0; i < bs.length; ++i) {
            sb.append(Converter.toHex(bs[i]));
        }
        return sb.toString();
    }

    public static byte[] getBytes(String str) {
        return Converter.getBytes(str, "ISO-8859-1");
    }

    public static byte[] getBytes(String str, String enc) {
        try {
            return str.getBytes(enc);
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }
}

