/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.util.List;
import org.planx.util.UnmodifiableArrayList;

public final class Array {
    private Array() {
    }

    public static int indexOf(byte[] array, byte value, int off, int len) {
        int pos = 0;
        for (int i = off; i < off + len; ++i) {
            if (array[i] != value) continue;
            pos = i;
            break;
        }
        if (pos < off || pos > off + len) {
            return -1;
        }
        return pos;
    }

    public static int compareTo(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return 0;
        }
        if (b1 == null) {
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        int len1 = b1.length;
        int len2 = b2.length;
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            if (b1[i] == b2[i]) continue;
            return b1[i] - b2[i];
        }
        return len1 - len2;
    }

    public static int[] ensureCapacity(int[] arr, int size, int minCapacity) {
        int oldCapacity = arr.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new int[newCapacity];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static int[][] ensureCapacity(int[][] arr, int size, int minCapacity) {
        int oldCapacity = ((int[][])arr).length;
        if (minCapacity > oldCapacity) {
            int[][] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new int[newCapacity][];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static byte[] ensureCapacity(byte[] arr, int size, int minCapacity) {
        int oldCapacity = arr.length;
        if (minCapacity > oldCapacity) {
            byte[] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new byte[newCapacity];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static CharSequence[] ensureCapacity(CharSequence[] arr, int size, int minCapacity) {
        int oldCapacity = arr.length;
        if (minCapacity > oldCapacity) {
            CharSequence[] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new CharSequence[newCapacity];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static CharSequence[][] ensureCapacity(CharSequence[][] arr, int size, int minCapacity) {
        int oldCapacity = arr.length;
        if (minCapacity > oldCapacity) {
            CharSequence[][] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new CharSequence[newCapacity][];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static List[] ensureCapacity(List[] arr, int size, int minCapacity) {
        int oldCapacity = arr.length;
        if (minCapacity > oldCapacity) {
            List[] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new List[newCapacity];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static Object[] ensureCapacity(Object[] arr, int size, int minCapacity) {
        int oldCapacity = arr.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = arr;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            arr = new Object[newCapacity];
            System.arraycopy(oldData, 0, arr, 0, size);
        }
        return arr;
    }

    public static int[] setLength(int[] arr, int length) {
        int oldLength = arr.length;
        if (oldLength == length) {
            return arr;
        }
        int[] newArr = new int[length];
        int size = oldLength < length ? oldLength : length;
        System.arraycopy(arr, 0, newArr, 0, size);
        return newArr;
    }

    public static byte[] setLength(byte[] arr, int length) {
        int oldLength = arr.length;
        if (oldLength == length) {
            return arr;
        }
        byte[] newArr = new byte[length];
        int size = oldLength < length ? oldLength : length;
        System.arraycopy(arr, 0, newArr, 0, size);
        return newArr;
    }

    public static <E> List<E> unmodifiableCopy(List<E> list) {
        Object[] arr = list.toArray();
        return new UnmodifiableArrayList<Object>(arr);
    }

    public static <E> List<E> unmodifiableCopy(E[] arr) {
        Object[] cp = new Object[arr.length];
        System.arraycopy(arr, 0, cp, 0, arr.length);
        return new UnmodifiableArrayList<Object>(cp);
    }

    public static <E> List<E> asUnmodifiableList(E[] arr) {
        return new UnmodifiableArrayList<E>(arr);
    }
}

