/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.number;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.IntExtractor;
import org.planx.msd.number.NumberDiscriminator;

public class IntegerDiscriminator
extends NumberDiscriminator<Integer> {
    public IntegerDiscriminator(Memory memory) {
        super(memory);
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends Integer, S> e) {
        IntExtractor intExt = new IntExtractor<U, S>(){

            @Override
            public int getLabel(U elm) {
                return (Integer)e.getLabel(elm);
            }

            @Override
            public S getValue(U elm) {
                return e.getValue(elm);
            }
        };
        return this.discriminate(values, intExt);
    }

    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, IntExtractor<U, S> e) {
        List<Object> list;
        int index;
        List[] dictionary = this.memory.dictionary;
        int[] used = this.memory.used;
        int used_size = 0;
        boolean isFinished = true;
        for (U elm : values) {
            index = e.getLabel(elm);
            if (index >> 16 != 0) {
                isFinished = false;
                break;
            }
            list = dictionary[index];
            if (list == null) {
                used[used_size++] = index;
                dictionary[index] = list = new ArrayList<S>();
            }
            list.add(e.getValue(elm));
        }
        if (isFinished) {
            ArrayList<List<S>> result2 = new ArrayList<List<S>>(used_size);
            for (int i = 0; i < used_size; ++i) {
                int index2 = used[i];
                result2.add(dictionary[index2]);
                dictionary[index2] = null;
            }
            return result2;
        }
        used_size = 0;
        for (U elm : values) {
            index = e.getLabel(elm) & 0xFFFF;
            list = dictionary[index];
            if (list == null) {
                used[used_size++] = index;
                dictionary[index] = list = new ArrayList();
            }
            list.add(elm);
        }
        ArrayList<List> result1 = new ArrayList<List>(used_size);
        for (int i = 0; i < used_size; ++i) {
            int index3 = used[i];
            result1.add(dictionary[index3]);
            dictionary[index3] = null;
        }
        ArrayList<List<S>> result2 = new ArrayList<List<S>>();
        for (List block : result1) {
            used_size = 0;
            for (Object elm : block) {
                int index4 = e.getLabel(elm);
                ArrayList<S> list2 = dictionary[index4 = index4 >> 16 & 0xFFFF];
                if (list2 == null) {
                    used[used_size++] = index4;
                    dictionary[index4] = list2 = new ArrayList<S>();
                }
                list2.add(e.getValue(elm));
            }
            for (int i = 0; i < used_size; ++i) {
                int index5 = used[i];
                result2.add(dictionary[index5]);
                dictionary[index5] = null;
            }
        }
        return result2;
    }

    @Override
    protected int bitsize() {
        return 32;
    }

    @Override
    protected <U> NumberDiscriminator.ChunkExtractor<U> chunkExtractor(Extractor<U, ? extends Integer, ?> e) {
        return new NumberDiscriminator.ChunkExtractor<U>(e){

            @Override
            public int getLabel(U elm) {
                Integer value = (Integer)this.e.getLabel(elm);
                return value >> this.offset & 0xFFFF;
            }
        };
    }
}

