package org.planx.xpath.expr.operator;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.object.*;

/**
 * A union between two expressions returning node sets.
 **/
public class UnionOperator extends Operator {
    public UnionOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    protected XObject evaluate(XObject o1, XObject o2, Navigator navigator)
                                                     throws XPathException {
        XNodeSet set1 = null, set2 = null;
        try {
            set1 = (XNodeSet) o1;
            set2 = (XNodeSet) o2;
            set1.addAll(set2);
            return set1;

        } catch (ClassCastException e) {
            String err = "Expression did not evaluate to an XNodeSet: ";
            if (set1 == null) throw new XPathException(err+e1);
            if (set2 == null) throw new XPathException(err+e2);
            throw e; // should never happen
        }
    }

    protected String operatorName() {
        return "|";
    }
}
