package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyException;

@Generated(value = "org.nuiton.wikitty.generator.WikittyDTOGenerator", date = "Sun Aug 09 10:50:53 CEST 2015")
public class WikittyLabelDTO implements WikittyLabel {

    @WikittyField(fqn = "WikittyLabel.labels")
    protected Set<String> labels = new LinkedHashSet<String>();

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public Set<String> getLabels() {
        return labels;
}

    @Override
    public void setLabels(Set<String> labels) {
        if (labels == null){
            this.labels = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.labels=new LinkedHashSet<String>(labels);
        }
        modificationCount++;
}

    @Override
    public void addAllLabels(Collection<String> labels) {
        if (this.labels == null){
            this.labels = new LinkedHashSet<String>();
        }
        this.labels.addAll(labels);
        modificationCount++;
}

    @Override
    public void addLabels(String... element) {
        if (this.labels == null){
            this.labels = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.labels.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeLabels(String... element) {
        if (this.labels != null) {
            for (String v : element) {
                labels.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearLabels() {
        if (this.labels != null) {
            labels.clear();
            modificationCount++;
        }
}

    public WikittyLabelDTO() {
}

    public WikittyLabelDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getStaticExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyLabel)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyLabel sourceCopy = (WikittyLabel)source;

        Set<String> labels = sourceCopy.getLabels();
        if (labels != null){
            setLabels(new LinkedHashSet<String>(labels));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

} //WikittyLabelDTO
