/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyGroup;

public class WikittyGroupDTO
implements WikittyGroup {
    @WikittyField(fqn="WikittyGroup.name")
    protected String name;
    @WikittyField(fqn="WikittyGroup.members")
    protected Set<String> members = new LinkedHashSet<String>();
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ++this.modificationCount;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public void setMembers(Set<String> members) {
        this.members = members == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(members);
        ++this.modificationCount;
    }

    public void addAllMembers(Collection<String> members) {
        if (this.members == null) {
            this.members = new LinkedHashSet<String>();
        }
        this.members.addAll(members);
        ++this.modificationCount;
    }

    public void addMembers(String ... element) {
        if (this.members == null) {
            this.members = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.members.add(v);
        }
        ++this.modificationCount;
    }

    public void removeMembers(String ... element) {
        if (this.members != null) {
            for (String v : element) {
                this.members.remove(element);
            }
            ++this.modificationCount;
        }
    }

    public void clearMembers() {
        if (this.members != null) {
            this.members.clear();
            ++this.modificationCount;
        }
    }

    public Set<Wikitty> getMembers(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        }
        return null;
    }

    public void setMembersEntity(Collection<Wikitty> members) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : members) {
            tmp.add(e.getWikittyId());
        }
        this.setMembers(tmp);
    }

    public void addAllMembersEntity(Collection<Wikitty> members) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : members) {
            tmp.add(e.getWikittyId());
        }
        this.addAllMembers(tmp);
    }

    public void addMembers(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.addMembers(tmp);
    }

    public void removeMembers(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.removeMembers(tmp);
    }

    public WikittyGroupDTO() {
    }

    public WikittyGroupDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getStaticExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getFieldAsObject(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyGroup)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyGroup sourceCopy = (WikittyGroup)source;
        this.setName(sourceCopy.getName());
        Set members = sourceCopy.getMembers();
        if (members != null) {
            this.setMembers(new LinkedHashSet<String>(members));
        }
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }
}

