/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisation;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyUser;

public class WikittyAuthorisationDTO
implements WikittyAuthorisation {
    @WikittyField(fqn="WikittyAuthorisation.owner")
    protected String owner;
    @WikittyField(fqn="WikittyAuthorisation.admin")
    protected Set<String> admin = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyAuthorisation.writer")
    protected Set<String> writer = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyAuthorisation.reader")
    protected Set<String> reader = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyAuthorisation.parent")
    protected Set<String> parent = new LinkedHashSet<String>();
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        ++this.modificationCount;
    }

    public WikittyUser getOwner(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        }
        return null;
    }

    public void setOwner(WikittyUser owner) {
        this.setOwner(owner.getWikittyId());
    }

    public Set<String> getAdmin() {
        return this.admin;
    }

    public void setAdmin(Set<String> admin) {
        this.admin = admin == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(admin);
        ++this.modificationCount;
    }

    public void addAllAdmin(Collection<String> admin) {
        if (this.admin == null) {
            this.admin = new LinkedHashSet<String>();
        }
        this.admin.addAll(admin);
        ++this.modificationCount;
    }

    public void addAdmin(String ... element) {
        if (this.admin == null) {
            this.admin = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.admin.add(v);
        }
        ++this.modificationCount;
    }

    public void removeAdmin(String ... element) {
        if (this.admin != null) {
            for (String v : element) {
                this.admin.remove(element);
            }
            ++this.modificationCount;
        }
    }

    public void clearAdmin() {
        if (this.admin != null) {
            this.admin.clear();
            ++this.modificationCount;
        }
    }

    public Set<Wikitty> getAdmin(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        }
        return null;
    }

    public void setAdminEntity(Collection<Wikitty> admin) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : admin) {
            tmp.add(e.getWikittyId());
        }
        this.setAdmin(tmp);
    }

    public void addAllAdminEntity(Collection<Wikitty> admin) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : admin) {
            tmp.add(e.getWikittyId());
        }
        this.addAllAdmin(tmp);
    }

    public void addAdmin(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.addAdmin(tmp);
    }

    public void removeAdmin(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.removeAdmin(tmp);
    }

    public Set<String> getWriter() {
        return this.writer;
    }

    public void setWriter(Set<String> writer) {
        this.writer = writer == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(writer);
        ++this.modificationCount;
    }

    public void addAllWriter(Collection<String> writer) {
        if (this.writer == null) {
            this.writer = new LinkedHashSet<String>();
        }
        this.writer.addAll(writer);
        ++this.modificationCount;
    }

    public void addWriter(String ... element) {
        if (this.writer == null) {
            this.writer = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.writer.add(v);
        }
        ++this.modificationCount;
    }

    public void removeWriter(String ... element) {
        if (this.writer != null) {
            for (String v : element) {
                this.writer.remove(element);
            }
            ++this.modificationCount;
        }
    }

    public void clearWriter() {
        if (this.writer != null) {
            this.writer.clear();
            ++this.modificationCount;
        }
    }

    public Set<Wikitty> getWriter(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        }
        return null;
    }

    public void setWriterEntity(Collection<Wikitty> writer) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : writer) {
            tmp.add(e.getWikittyId());
        }
        this.setWriter(tmp);
    }

    public void addAllWriterEntity(Collection<Wikitty> writer) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : writer) {
            tmp.add(e.getWikittyId());
        }
        this.addAllWriter(tmp);
    }

    public void addWriter(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.addWriter(tmp);
    }

    public void removeWriter(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.removeWriter(tmp);
    }

    public Set<String> getReader() {
        return this.reader;
    }

    public void setReader(Set<String> reader) {
        this.reader = reader == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(reader);
        ++this.modificationCount;
    }

    public void addAllReader(Collection<String> reader) {
        if (this.reader == null) {
            this.reader = new LinkedHashSet<String>();
        }
        this.reader.addAll(reader);
        ++this.modificationCount;
    }

    public void addReader(String ... element) {
        if (this.reader == null) {
            this.reader = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.reader.add(v);
        }
        ++this.modificationCount;
    }

    public void removeReader(String ... element) {
        if (this.reader != null) {
            for (String v : element) {
                this.reader.remove(element);
            }
            ++this.modificationCount;
        }
    }

    public void clearReader() {
        if (this.reader != null) {
            this.reader.clear();
            ++this.modificationCount;
        }
    }

    public Set<Wikitty> getReader(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        }
        return null;
    }

    public void setReaderEntity(Collection<Wikitty> reader) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : reader) {
            tmp.add(e.getWikittyId());
        }
        this.setReader(tmp);
    }

    public void addAllReaderEntity(Collection<Wikitty> reader) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : reader) {
            tmp.add(e.getWikittyId());
        }
        this.addAllReader(tmp);
    }

    public void addReader(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.addReader(tmp);
    }

    public void removeReader(Wikitty ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.removeReader(tmp);
    }

    public Set<String> getParent() {
        return this.parent;
    }

    public void setParent(Set<String> parent) {
        this.parent = parent == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(parent);
        ++this.modificationCount;
    }

    public void addAllParent(Collection<String> parent) {
        if (this.parent == null) {
            this.parent = new LinkedHashSet<String>();
        }
        this.parent.addAll(parent);
        ++this.modificationCount;
    }

    public void addParent(String ... element) {
        if (this.parent == null) {
            this.parent = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.parent.add(v);
        }
        ++this.modificationCount;
    }

    public void removeParent(String ... element) {
        if (this.parent != null) {
            for (String v : element) {
                this.parent.remove(element);
            }
            ++this.modificationCount;
        }
    }

    public void clearParent() {
        if (this.parent != null) {
            this.parent.clear();
            ++this.modificationCount;
        }
    }

    public Set<WikittyAuthorisation> getParent(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        }
        return null;
    }

    public void setParentEntity(Collection<WikittyAuthorisation> parent) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (WikittyAuthorisation e : parent) {
            tmp.add(e.getWikittyId());
        }
        this.setParent(tmp);
    }

    public void addAllParentEntity(Collection<WikittyAuthorisation> parent) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (WikittyAuthorisation e : parent) {
            tmp.add(e.getWikittyId());
        }
        this.addAllParent(tmp);
    }

    public void addParent(WikittyAuthorisation ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.addParent(tmp);
    }

    public void removeParent(WikittyAuthorisation ... element) {
        String[] tmp = new String[element.length];
        for (int i = 0; i < element.length; ++i) {
            tmp[i] = element[i].getWikittyId();
        }
        this.removeParent(tmp);
    }

    public WikittyAuthorisationDTO() {
    }

    public WikittyAuthorisationDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getStaticExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getFieldAsObject(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        Set parent;
        Set reader;
        Set writer;
        if (!(source instanceof WikittyAuthorisation)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyAuthorisation sourceCopy = (WikittyAuthorisation)source;
        this.setOwner(sourceCopy.getOwner());
        Set admin = sourceCopy.getAdmin();
        if (admin != null) {
            this.setAdmin(new LinkedHashSet<String>(admin));
        }
        if ((writer = sourceCopy.getWriter()) != null) {
            this.setWriter(new LinkedHashSet<String>(writer));
        }
        if ((reader = sourceCopy.getReader()) != null) {
            this.setReader(new LinkedHashSet<String>(reader));
        }
        if ((parent = sourceCopy.getParent()) != null) {
            this.setParent(new LinkedHashSet<String>(parent));
        }
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }
}

