/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryParser;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.query.function.FunctionAvg;
import org.nuiton.wikitty.query.function.FunctionCount;
import org.nuiton.wikitty.query.function.FunctionDistinct;
import org.nuiton.wikitty.query.function.FunctionFieldValue;
import org.nuiton.wikitty.query.function.FunctionFusion;
import org.nuiton.wikitty.query.function.FunctionMax;
import org.nuiton.wikitty.query.function.FunctionMin;
import org.nuiton.wikitty.query.function.FunctionSum;
import org.nuiton.wikitty.query.function.FunctionValue;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;
import org.nuiton.wikitty.query.function.WikittyQueryFunctionWrapper;

public abstract class WikittyQueryMakerAbstract<M extends WikittyQueryMakerAbstract> {
    private static Log log = LogFactory.getLog(WikittyQueryMakerAbstract.class);
    protected WikittyQuery query;
    protected Condition condition;
    protected Deque<Condition> openStack = new LinkedList<Condition>();
    protected Deque<WikittyQueryFunction> openStackFunction = new LinkedList<WikittyQueryFunction>();

    public WikittyQueryMakerAbstract() {
    }

    public WikittyQueryMakerAbstract(WikittyQuery query) {
        this.query = query;
    }

    protected abstract M asM();

    public Condition getCondition() {
        return this.condition;
    }

    public WikittyQuery getQuery() {
        if (this.query == null) {
            this.query = new WikittyQuery();
        }
        this.query.setCondition(this.getCondition());
        return this.query;
    }

    protected Deque<Condition> getOpenStack() {
        if (this.openStack == null) {
            throw new WikittyException("You can't create condition if you have used setCondition method or close last condition");
        }
        return this.openStack;
    }

    protected void addCondition(Condition c) {
        this.addCondition(c, false);
    }

    protected void addCondition(Condition c, boolean terminal) {
        Condition parent = this.getOpenStack().peek();
        if (!terminal) {
            this.getOpenStack().push(c);
        }
        if (parent == null) {
            this.condition = c;
        } else {
            parent.addCondition(c);
            if (!terminal) {
                this.closeIfNecessary();
            }
        }
    }

    protected void closeIfNecessary() {
        while (this.getOpenStack().peek() != null && !this.getOpenStack().peek().waitCondition()) {
            this.getOpenStack().poll();
        }
        if (this.getOpenStack().size() == 0) {
            this.openStack = null;
        }
    }

    protected Deque<WikittyQueryFunction> getOpenStackFunction() {
        Condition c = this.getOpenStack().peek();
        if (c instanceof Select) {
            return this.openStackFunction;
        }
        throw new IllegalStateException("You can use function only in Select clause");
    }

    public M addFunction(WikittyQueryFunction f) {
        WikittyQueryFunction parent = this.getOpenStackFunction().peek();
        this.getOpenStackFunction().push(f);
        if (parent != null) {
            parent.addArgs(f);
        }
        return this.asM();
    }

    public M where() {
        Condition c = this.getOpenStack().peek();
        if (c != null) {
            if (c instanceof Select) {
                WikittyQueryFunction root = this.getOpenStackFunction().peekLast();
                if (root != null) {
                    Select select = (Select)c;
                    WikittyQueryFunction current = select.getFunction();
                    if (current == null) {
                        select.setFunction(root);
                    } else if (current instanceof FunctionFusion) {
                        current.addArgs(root);
                    } else {
                        FunctionFusion fusion = new FunctionFusion(select.getFunction(), root);
                        select.setFunction(fusion);
                    }
                }
                this.getOpenStackFunction().clear();
            } else {
                throw new IllegalStateException("You can use Where only after select or at beginning of condition");
            }
        }
        return this.asM();
    }

    public M fieldValue(String fieldName) {
        return this.fieldValue(fieldName, null);
    }

    public M fieldValue(Element fieldName) {
        return this.fieldValue(fieldName.getValue(), null);
    }

    public M fieldValue(Element fieldName, String alias) {
        return this.fieldValue(fieldName.getValue());
    }

    public M fieldValue(String fieldName, String alias) {
        FunctionFieldValue f = new FunctionFieldValue(alias, fieldName);
        this.addFunction(f);
        return this.close();
    }

    public M avg() {
        return this.avg((String)null, null);
    }

    public M avg(String field) {
        return this.avg(field, null);
    }

    public M avg(Element field) {
        return this.avg(field.getValue(), null);
    }

    public M avg(Element field, String alias) {
        return this.avg(field.getValue(), alias);
    }

    public M avg(String field, String alias) {
        if (field == null) {
            FunctionAvg f = new FunctionAvg(alias);
            this.addFunction(f);
        } else {
            FunctionAvg f = new FunctionAvg(alias, new FunctionFieldValue(null, field));
            this.addFunction(f);
            this.close();
        }
        return this.asM();
    }

    public M count() {
        return this.count((String)null, null);
    }

    public M count(String field) {
        return this.count(field, null);
    }

    public M count(Element field) {
        return this.count(field.getValue(), null);
    }

    public M count(Element field, String alias) {
        return this.count(field.getValue(), alias);
    }

    public M count(String field, String alias) {
        if (field == null) {
            FunctionCount f = new FunctionCount(alias);
            this.addFunction(f);
        } else {
            FunctionCount f = new FunctionCount(alias, new FunctionFieldValue(null, field));
            this.addFunction(f);
            this.close();
        }
        return this.asM();
    }

    public M max() {
        return this.max((String)null, null);
    }

    public M max(String field) {
        return this.max(field, null);
    }

    public M max(Element field) {
        return this.max(field.getValue(), null);
    }

    public M max(Element field, String alias) {
        return this.max(field.getValue(), alias);
    }

    public M max(String field, String alias) {
        if (field == null) {
            FunctionMax f = new FunctionMax(alias);
            this.addFunction(f);
        } else {
            FunctionMax f = new FunctionMax(alias, new FunctionFieldValue(null, field));
            this.addFunction(f);
            this.close();
        }
        return this.asM();
    }

    public M min() {
        return this.min((String)null, null);
    }

    public M min(String field) {
        return this.min(field, null);
    }

    public M min(Element field) {
        return this.min(field.getValue(), null);
    }

    public M min(Element field, String alias) {
        return this.min(field.getValue(), alias);
    }

    public M min(String field, String alias) {
        if (field == null) {
            FunctionMin f = new FunctionMin(alias);
            this.addFunction(f);
        } else {
            FunctionMin f = new FunctionMin(alias, new FunctionFieldValue(null, field));
            this.addFunction(f);
            this.close();
        }
        return this.asM();
    }

    public M sum() {
        return this.sum((String)null, null);
    }

    public M sum(String field) {
        return this.sum(field, null);
    }

    public M sum(Element field) {
        return this.sum(field.getValue(), null);
    }

    public M sum(Element field, String alias) {
        return this.sum(field.getValue(), alias);
    }

    public M sum(String field, String alias) {
        if (field == null) {
            FunctionSum f = new FunctionSum(alias);
            this.addFunction(f);
        } else {
            FunctionSum f = new FunctionSum(alias, new FunctionFieldValue(null, field));
            this.addFunction(f);
            this.close();
        }
        return this.asM();
    }

    public M distinct() {
        FunctionDistinct f = new FunctionDistinct(new WikittyQueryFunction[0]);
        return this.addFunction(f);
    }

    public M distinct(String ... fields) {
        boolean mustClose = false;
        FunctionDistinct f = new FunctionDistinct(new WikittyQueryFunction[0]);
        if (fields != null && fields.length > 0) {
            mustClose = true;
            for (String fieldName : fields) {
                f.addArgs(new FunctionFieldValue(null, fieldName));
            }
        }
        this.addFunction(f);
        if (mustClose) {
            this.close();
        }
        return this.asM();
    }

    public M distinct(Element one, Element ... fields) {
        ArrayList<String> l = new ArrayList<String>();
        if (one != null) {
            l.add(one.getValue());
        }
        if (fields != null) {
            for (Element e : fields) {
                l.add(e.getValue());
            }
        }
        return this.distinct(l.toArray(new String[l.size()]));
    }

    public M function(String method, Object ... args) {
        return this.function(method, null, args);
    }

    public M function(String method, String alias, Object ... args) {
        if (StringUtils.startsWith((CharSequence)method, (CharSequence)"#")) {
            method = this.getClass().getName() + method;
        }
        WikittyQueryFunctionWrapper f = new WikittyQueryFunctionWrapper(method, alias, new WikittyQueryFunction[0]);
        boolean mustClose = false;
        if (args != null && args.length > 0) {
            mustClose = true;
            for (Object o : args) {
                if (o instanceof WikittyQueryFunction) {
                    f.addArgs((WikittyQueryFunction)o);
                    continue;
                }
                f.addArgs(new FunctionValue(null, o));
            }
        }
        this.addFunction(f);
        if (mustClose) {
            this.close();
        }
        return this.asM();
    }

    protected static ConditionValue convertToConditionValue(Object o) {
        ConditionValue result;
        if (o instanceof ConditionValue) {
            result = (ConditionValue)o;
        } else {
            String s = WikittyUtil.toString(o);
            result = new ConditionValueString(s);
        }
        return result;
    }

    public M value(Object value) {
        Condition c = this.getOpenStack().peek();
        if (c instanceof Select) {
            FunctionValue f = new FunctionValue(null, value);
            this.addFunction(f);
            this.close();
        } else {
            ConditionValue v = WikittyQueryMakerAbstract.convertToConditionValue(value);
            this.addCondition(v);
        }
        return this.asM();
    }

    public M condition(Condition c) {
        this.addCondition(c, true);
        return this.asM();
    }

    public M parse(String query, boolean includeExtra) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            WikittyQuery filter = WikittyQueryParser.parse(query);
            this.addCondition(filter.getCondition(), true);
            if (includeExtra) {
                WikittyQuery q = this.getQuery();
                q.setOffset(filter.getOffset());
                q.setLimit(filter.getLimit());
                q.setWikittyFieldSearchDepth(filter.getWikittyFieldSearchDepth());
            }
        } else {
            this.addCondition(new True());
        }
        return this.asM();
    }

    public M parse(String query) {
        return this.parse(query, false);
    }

    public M wikitty(Wikitty w) {
        WikittyQueryMaker result = (WikittyQueryMaker)new WikittyQueryMaker().and();
        result.extContainsAll(w.getExtensionNames());
        for (String fqfieldName : w.fieldNames()) {
            Object value = w.getFqField(fqfieldName);
            if (value == null) continue;
            FieldType type = w.getFieldType(fqfieldName);
            if (type.isCollection()) {
                result.containsAll(fqfieldName, (Collection)value);
                continue;
            }
            result.eq(fqfieldName, value);
        }
        this.addCondition(result.getCondition());
        return this.asM();
    }

    public M wikitty(BusinessEntityImpl e) {
        Wikitty w = e.getWikitty();
        return this.wikitty(w);
    }

    public M containsAll(Element element) {
        this.addCondition(new ContainsAll(element));
        return this.asM();
    }

    public M containsAll(String element) {
        return this.containsAll(Element.get(element));
    }

    public <E> M containsAll(String fqfield, Collection<E> values) {
        return this.containsAll(Element.get(fqfield), values);
    }

    public <E> M containsAll(Element element, Collection<E> values) {
        this.containsAll(element);
        for (E e : values) {
            this.value(e);
        }
        this.close();
        return this.asM();
    }

    public <E> M containsAll(String fqfield, E value1, E ... values) {
        LinkedList<E> l = new LinkedList<E>();
        l.add(value1);
        l.addAll(Arrays.asList(values));
        return this.containsAll(fqfield, l);
    }

    public M containsOne(Element element) {
        this.addCondition(new ContainsOne(element));
        return this.asM();
    }

    public M containsOne(String element) {
        return this.containsOne(Element.get(element));
    }

    public <E> M containsOne(String fqfield, Collection<E> values) {
        return this.containsOne(Element.get(fqfield), values);
    }

    public <E> M containsOne(Element element, Collection<E> values) {
        this.containsOne(element);
        for (E e : values) {
            this.value(e);
        }
        this.close();
        return this.asM();
    }

    public <E> M containsOne(String fqfield, E value1, E ... values) {
        LinkedList<E> l = new LinkedList<E>();
        l.add(value1);
        l.addAll(Arrays.asList(values));
        return this.containsOne(fqfield, l);
    }

    public M eq(Element element) {
        this.addCondition(new Equals(element));
        return this.asM();
    }

    public M eq(String fqfield, Object value) {
        return this.eq(Element.get(fqfield), value);
    }

    public M eq(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new Equals(element, s));
        return this.asM();
    }

    public M eqIgnoreCaseAndAccent(Element element) {
        this.addCondition(new Equals(element, true));
        return this.asM();
    }

    public M eqIgnoreCaseAndAccent(String fqfield, Object value) {
        return this.eqIgnoreCaseAndAccent(Element.get(fqfield), value);
    }

    public M eqIgnoreCaseAndAccent(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new Equals(element, s, true));
        return this.asM();
    }

    public M exteq(String extensionName) {
        return this.eq(Element.EXTENSION, (Object)extensionName);
    }

    public M ideq(Object idOrWikitty) {
        return this.eq(Element.ID, idOrWikitty);
    }

    public M extContainsAll(Collection<String> extensionNames) {
        return this.containsAll(Element.EXTENSION, extensionNames);
    }

    public M extContainsAll(String ext1, String ... exts) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(ext1);
        l.addAll(Arrays.asList(exts));
        return this.containsAll(Element.EXTENSION, l);
    }

    public M extContainsOne(Collection<String> extensionNames) {
        return this.containsOne(Element.EXTENSION, extensionNames);
    }

    public M extContainsOne(String ext1, String ... exts) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(ext1);
        l.addAll(Arrays.asList(exts));
        return this.containsOne(Element.EXTENSION, l);
    }

    public M ne(Element element) {
        this.addCondition(new NotEquals(element));
        return this.asM();
    }

    public M ne(String fqfield, Object value) {
        return this.ne(Element.get(fqfield), value);
    }

    public M ne(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new NotEquals(element, s));
        return this.asM();
    }

    public M neIgnoreCaseAndAccent(Element element) {
        this.addCondition(new NotEquals(element, true));
        return this.asM();
    }

    public M neIgnoreCaseAndAccent(String fqfield, Object value) {
        return this.neIgnoreCaseAndAccent(Element.get(fqfield), value);
    }

    public M neIgnoreCaseAndAccent(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new NotEquals(element, s, true));
        return this.asM();
    }

    public M extne(String extensionName) {
        return this.ne(Element.EXTENSION, (Object)extensionName);
    }

    public M idne(Object idOrWikitty) {
        return this.ne(Element.ID, idOrWikitty);
    }

    public M gt(Element element) {
        this.addCondition(new Greater(element));
        return this.asM();
    }

    public M gt(String fqfield, Object value) {
        return this.gt(Element.get(fqfield), value);
    }

    public M gt(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new Greater(element, s));
        return this.asM();
    }

    public M ge(Element element) {
        this.addCondition(new GreaterOrEquals(element));
        return this.asM();
    }

    public M ge(String fqfield, Object value) {
        return this.ge(Element.get(fqfield), value);
    }

    public M ge(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new GreaterOrEquals(element, s));
        return this.asM();
    }

    public M lt(Element element) {
        this.addCondition(new Less(element));
        return this.asM();
    }

    public M lt(String fqfield, Object value) {
        return this.lt(Element.get(fqfield), value);
    }

    public M lt(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new Less(element, s));
        return this.asM();
    }

    public M le(Element element) {
        this.addCondition(new LessOrEquals(element));
        return this.asM();
    }

    public M le(String fqfield, Object value) {
        return this.le(Element.get(fqfield), value);
    }

    public M le(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new LessOrEquals(element, s));
        return this.asM();
    }

    public M bw(Element element) {
        this.addCondition(new Between(element));
        return this.asM();
    }

    public M bw(String fqfield, Object lowerValue, Object upperValue) {
        return this.bw(Element.get(fqfield), lowerValue, upperValue);
    }

    public M bw(Element element, Object lowerValue, Object upperValue) {
        ConditionValue min = WikittyQueryMakerAbstract.convertToConditionValue(lowerValue);
        ConditionValue max = WikittyQueryMakerAbstract.convertToConditionValue(upperValue);
        this.addCondition(new Between(element, min, max));
        return this.asM();
    }

    public M sw(String fqfield, String value) {
        return this.sw(Element.get(fqfield), value);
    }

    public M sw(Element element, String value) {
        this.addCondition(new Equals(element, value + "*"));
        return this.asM();
    }

    public M notsw(String fqfield, String value) {
        return this.notsw(Element.get(fqfield), value);
    }

    public M notsw(Element element, String value) {
        this.addCondition(new NotEquals(element, value + "*"));
        return this.asM();
    }

    public M ew(String fqfield, Object value) {
        return this.ew(Element.get(fqfield), value);
    }

    public M ew(Element element, Object value) {
        this.addCondition(new Equals(element, "*" + value));
        return this.asM();
    }

    public M notew(String fqfield, Object value) {
        return this.notew(Element.get(fqfield), value);
    }

    public M notew(Element element, Object value) {
        this.addCondition(new NotEquals(element, "*" + value));
        return this.asM();
    }

    public M keyword() {
        this.addCondition(new Keyword());
        return this.asM();
    }

    public M keyword(Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        this.addCondition(new Keyword().addCondition(s));
        return this.asM();
    }

    public M isNull(String fqfield) {
        return this.isNull(Element.get(fqfield));
    }

    public M isNull(Element element) {
        this.addCondition(new Null(element));
        return this.asM();
    }

    public M isNotNull(String fqfield) {
        return this.isNotNull(Element.get(fqfield));
    }

    public M isNotNull(Element element) {
        this.addCondition(new NotNull(element));
        return this.asM();
    }

    public M rFalse() {
        this.addCondition(new False());
        return this.asM();
    }

    public M rTrue() {
        this.addCondition(new True());
        return this.asM();
    }

    public M like(Element element) {
        this.addCondition(new Like(element));
        return this.asM();
    }

    public M like(String fqfield, Object value) {
        return this.like(Element.get(fqfield), value);
    }

    public M like(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        Like c = new Like(element, s);
        this.addCondition(c);
        return this.asM();
    }

    public M unlike(Element element) {
        this.addCondition(new Unlike(element));
        return this.asM();
    }

    public M unlike(String fqfield, Object value) {
        return this.unlike(Element.get(fqfield), value);
    }

    public M unlike(Element element, Object value) {
        ConditionValue s = WikittyQueryMakerAbstract.convertToConditionValue(value);
        Unlike c = new Unlike(element, s);
        this.addCondition(c);
        return this.asM();
    }

    public M not() {
        Not child = new Not();
        this.addCondition(child);
        return this.asM();
    }

    public M or() {
        Or child = new Or(new Condition[0]);
        this.addCondition(child);
        return this.asM();
    }

    public M and() {
        And child = new And(new Condition[0]);
        this.addCondition(child);
        return this.asM();
    }

    public M select() {
        return this.select((WikittyQueryFunction)null);
    }

    public M select(WikittyQueryFunction f) {
        Select child = new Select(f);
        this.addCondition(child);
        return this.asM();
    }

    public M select(String e) {
        return this.select(Element.get(e));
    }

    public M select(Element e) {
        return this.select(new FunctionFieldValue(null, e.getValue()));
    }

    public M close() {
        Condition c = this.getOpenStack().peek();
        WikittyQueryFunction f = this.openStackFunction.peek();
        if (c instanceof Select && f != null) {
            if (this.openStackFunction.size() == 1) {
                this.where();
            } else {
                this.openStackFunction.pop();
            }
        } else {
            this.getOpenStack().pop();
            this.closeIfNecessary();
        }
        return this.asM();
    }

    public WikittyQuery end() {
        WikittyQuery result = this.getQuery();
        result.setCondition(this.getCondition());
        this.openStack = null;
        return result;
    }
}

