/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.tapestry5.services;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Response;
import org.nuiton.web.tapestry5.services.ServiceAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationFilter<U, A extends Annotation>
implements ComponentRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuthenticationFilter.class);
    private final PageRenderLinkSource pageRender;
    private final ComponentSource componentSource;
    private final Response response;
    private final ServiceAuthentication<U> serviceAuthentication;
    protected Class<A> annotationClass;

    protected abstract Class<?> getRedirectPage(AuthenticationRedirect var1);

    public AbstractAuthenticationFilter(PageRenderLinkSource renderLinkSource, ComponentSource componentSource, Response response, ServiceAuthentication<U> serviceAuthentication, Class<A> annotationClass) {
        this.pageRender = renderLinkSource;
        this.componentSource = componentSource;
        this.response = response;
        this.serviceAuthentication = serviceAuthentication;
        this.annotationClass = annotationClass;
        if (logger.isTraceEnabled()) {
            logger.trace("Construct");
        }
    }

    public void handleComponentEvent(ComponentEventRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("handleComponentEvent");
        }
        if (this.redirectUnauthorizedUser(parameters.getActivePageName())) {
            return;
        }
        handler.handleComponentEvent(parameters);
    }

    public void handlePageRender(PageRenderRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("handlePageRender");
        }
        if (this.redirectUnauthorizedUser(parameters.getLogicalPageName())) {
            return;
        }
        handler.handlePageRender(parameters);
    }

    protected boolean redirectUnauthorizedUser(String pageName) throws IOException {
        Component page = this.componentSource.getPage(pageName);
        if (logger.isTraceEnabled()) {
            logger.trace("Page name : " + pageName);
            logger.trace("Page class : " + page.getClass());
            logger.trace("RequiresLogin annotation : " + page.getClass().isAnnotationPresent(this.annotationClass));
            logger.trace("User in session : " + this.serviceAuthentication.isUserConnected());
        }
        if (!page.getClass().isAnnotationPresent(this.annotationClass)) {
            return false;
        }
        AuthenticationRedirect redirectType = AuthenticationRedirect.NOT_CONNECTED;
        if (this.serviceAuthentication.isUserConnected()) {
            U user = this.serviceAuthentication.getUserConnected();
            if (logger.isTraceEnabled()) {
                logger.trace("User connected : " + user);
                logger.trace("User allowed : " + this.serviceAuthentication.isAllowed(page.getClass()));
            }
            if (this.serviceAuthentication.isAllowed(page.getClass())) {
                return false;
            }
            redirectType = AuthenticationRedirect.NOT_ALLOWED;
        }
        Class<?> redirectPage = this.getRedirectPage(redirectType);
        Link link = this.pageRender.createPageRenderLinkWithContext(redirectPage, new Object[]{pageName});
        if (logger.isTraceEnabled()) {
            logger.trace("Redirection to " + redirectPage.getSimpleName() + " page...");
        }
        this.response.sendRedirect(link);
        return true;
    }

    protected static enum AuthenticationRedirect {
        NOT_CONNECTED,
        NOT_ALLOWED;

    }
}

