/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.web.struts2.TopiaTransactionAware;

public abstract class TopiaTransactionInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(TopiaTransactionInterceptor.class);
    private static final long serialVersionUID = 1L;
    public static final String[] DEFAULT_EXCLUDE_METHODS = new String[]{"beginTransaction", "closeContext", "clear"};
    protected Set<String> excludeMethods;

    public Set<String> getExcludeMethods() {
        return this.excludeMethods;
    }

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet((String)excludeMethods);
    }

    protected abstract TopiaContext beginTransaction() throws TopiaException;

    public void init() {
        super.init();
        if (this.getExcludeMethods() == null) {
            this.excludeMethods = new HashSet<String>(Arrays.asList(DEFAULT_EXCLUDE_METHODS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        TopiaTransactionAware transactionAware = null;
        Object action = invocation.getProxy().getAction();
        if (action instanceof TopiaTransactionAware) {
            transactionAware = (TopiaTransactionAware)action;
        }
        TopiaContext transaction = null;
        if (transactionAware != null) {
            transaction = this.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Open transaction " + transaction));
            }
            TopiaContext proxy = (TopiaContext)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{TopiaContext.class, TopiaContextImplementor.class}, (InvocationHandler)new TopiaTransactionProxyInvocationHandler(transaction));
            transactionAware.setTransaction(proxy);
        }
        try {
            String string = invocation.invoke();
            return string;
        }
        finally {
            if (transactionAware != null && transaction != null && !transaction.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Close transaction " + transaction));
                }
                transaction.closeContext();
            }
        }
    }

    class TopiaTransactionProxyInvocationHandler
    implements InvocationHandler {
        protected final TopiaContext tx;

        TopiaTransactionProxyInvocationHandler(TopiaContext tx) {
            this.tx = tx;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (TopiaTransactionInterceptor.this.getExcludeMethods().contains(methodName)) {
                throw new IllegalAccessException("Not allowed to access method " + methodName + " on " + proxy);
            }
            try {
                Object result = method.invoke((Object)this.tx, args);
                return result;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not execute method " + method.getName()), (Throwable)eee);
                }
                throw eee;
            }
        }
    }
}

